/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import java.security.KeyPair;
import java.util.List;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.ServerFactoryManager;

public class ServerSession
extends AbstractSession {
    protected static final long MAX_PACKETS = 0x80000000L;
    private long maxBytes = Math.max(32L, this.getLongProperty("rekey-bytes-limit", this.maxBytes));
    private long maxKeyInterval = this.getLongProperty("rekey-time-limit", this.maxKeyInterval);

    public ServerSession(ServerFactoryManager server, IoSession ioSession) throws Exception {
        super(true, server, ioSession);
        this.log.info("Server session created from {}", (Object)ioSession.getRemoteAddress());
        this.sendServerIdentification();
    }

    public String getNegotiated(int index) {
        return this.negotiated[index];
    }

    public ServerFactoryManager getFactoryManager() {
        return (ServerFactoryManager)this.factoryManager;
    }

    protected void checkKeys() {
    }

    public void startService(String name) throws Exception {
        this.currentService = ServiceFactory.Utils.create(this.getFactoryManager().getServiceFactories(), name, this);
    }

    protected void serviceAccept() throws IOException {
        this.disconnect(2, "Unsupported packet: SSH_MSG_SERVICE_ACCEPT");
    }

    protected void checkRekey() throws IOException {
        if (this.kexState.get() == 4 && (this.inPackets > 0x80000000L || this.outPackets > 0x80000000L || this.inBytes > this.maxBytes || this.outBytes > this.maxBytes || this.maxKeyInterval > 0L && System.currentTimeMillis() - this.lastKeyTime > this.maxKeyInterval)) {
            this.reExchangeKeys();
        }
    }

    private void sendServerIdentification() {
        this.serverVersion = this.getFactoryManager().getProperties() != null && this.getFactoryManager().getProperties().get("server-identification") != null ? "SSH-2.0-" + this.getFactoryManager().getProperties().get("server-identification") : "SSH-2.0-" + this.getFactoryManager().getVersion();
        this.sendIdentification(this.serverVersion);
    }

    protected void sendKexInit() throws IOException {
        ServerFactoryManager manager = this.getFactoryManager();
        KeyPairProvider kpp = manager.getKeyPairProvider();
        String hostKeyTypes = kpp.getKeyTypes();
        List<String> supported = NamedFactory.Utils.getNameList(manager.getSignatureFactories());
        String[] provided = hostKeyTypes.split(",");
        StringBuilder resolvedHostKeys = null;
        for (int index = 0; index < provided.length; ++index) {
            String keyType = provided[index];
            if (!supported.contains(keyType)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sendKexInit(" + hostKeyTypes + ") " + keyType + " not in list of supported: " + supported);
                }
                if (resolvedHostKeys != null) continue;
                resolvedHostKeys = new StringBuilder(hostKeyTypes.length());
                for (int supportedIndex = 0; supportedIndex < index; ++supportedIndex) {
                    if (supportedIndex > 0) {
                        resolvedHostKeys.append(',');
                    }
                    resolvedHostKeys.append(provided[supportedIndex]);
                }
                continue;
            }
            if (resolvedHostKeys == null) continue;
            if (resolvedHostKeys.length() > 0) {
                resolvedHostKeys.append(',');
            }
            resolvedHostKeys.append(keyType);
        }
        if (resolvedHostKeys != null) {
            if (resolvedHostKeys.length() <= 0) {
                throw new SshException(9, "sendKexInit(" + hostKeyTypes + ") none of the keys appears in supported list: " + supported);
            }
            hostKeyTypes = resolvedHostKeys.toString();
        }
        this.serverProposal = this.createProposal(hostKeyTypes);
        this.I_S = this.sendKexInit(this.serverProposal);
    }

    protected boolean readIdentification(Buffer buffer) throws IOException {
        this.clientVersion = this.doReadIdentification(buffer, true);
        if (this.clientVersion == null) {
            return false;
        }
        this.log.debug("Client version string: {}", (Object)this.clientVersion);
        if (!this.clientVersion.startsWith("SSH-2.0-")) {
            String msg = "Unsupported protocol version: " + this.clientVersion;
            this.ioSession.write(new Buffer((msg + "\n").getBytes())).addListener(new SshFutureListener<IoWriteFuture>(){

                @Override
                public void operationComplete(IoWriteFuture future) {
                    ServerSession.this.close(true);
                }
            });
            throw new SshException(msg);
        }
        this.kexState.set(1);
        this.sendKexInit();
        return true;
    }

    protected void receiveKexInit(Buffer buffer) throws IOException {
        this.clientProposal = new String[10];
        this.I_C = this.receiveKexInit(buffer, this.clientProposal);
    }

    public KeyPair getHostKey() {
        return this.factoryManager.getKeyPairProvider().loadKey(this.negotiated[1]);
    }

    protected int getActiveSessionCountForUser(String userName) {
        int totalCount = 0;
        for (IoSession is : this.ioSession.getService().getManagedSessions().values()) {
            ServerSession session = (ServerSession)ServerSession.getSession(is, true);
            if (session == null || session.getUsername() == null || !session.getUsername().equals(userName)) continue;
            ++totalCount;
        }
        return totalCount;
    }

    public long getId() {
        return this.ioSession.getId();
    }
}

