/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.io.PrintStream;
import org.apache.karaf.log.core.LogEventFormatter;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="display", description="Displays log entries.")
@Service
public class DisplayLog
implements Action {
    public static final int ERROR_INT = 3;
    public static final int WARN_INT = 4;
    public static final int INFO_INT = 6;
    public static final int DEBUG_INT = 7;
    @Option(name="-n", aliases={}, description="Number of entries to display", required=false, multiValued=false)
    int entries;
    @Option(name="-p", aliases={}, description="Pattern for formatting the output", required=false, multiValued=false)
    String overridenPattern;
    @Option(name="--no-color", description="Disable syntax coloring of log events", required=false, multiValued=false)
    boolean noColor;
    @Option(name="-l", aliases={"--level"}, description="The minimal log level to display", required=false, multiValued=false)
    @Completion(value=StringsCompleter.class, values={"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "DEFAULT"})
    String level;
    @Argument(index=0, name="logger", description="The name of the logger. This can be ROOT, ALL, or the name of a logger specified in the org.ops4j.pax.logger.cfg file.", required=false, multiValued=false)
    String logger;
    @Reference
    LogService logService;
    @Reference
    LogEventFormatter formatter;

    public Object execute() throws Exception {
        int minLevel = Integer.MAX_VALUE;
        if (this.level != null) {
            switch (this.level.toLowerCase()) {
                case "debug": {
                    minLevel = 7;
                    break;
                }
                case "info": {
                    minLevel = 6;
                    break;
                }
                case "warn": {
                    minLevel = 4;
                    break;
                }
                case "error": {
                    minLevel = 3;
                }
            }
        }
        PrintStream out = System.out;
        Iterable<PaxLoggingEvent> le = this.logService.getEvents(this.entries == 0 ? Integer.MAX_VALUE : this.entries);
        for (PaxLoggingEvent event : le) {
            int sl = event.getLevel().getSyslogEquivalent();
            if (sl > minLevel) continue;
            this.printEvent(out, event);
        }
        out.println();
        return null;
    }

    protected boolean checkIfFromRequestedLog(PaxLoggingEvent event) {
        return event.getLoggerName().contains(this.logger);
    }

    protected void printEvent(PrintStream out, PaxLoggingEvent event) {
        try {
            if (this.logger != null && event != null && this.checkIfFromRequestedLog(event)) {
                out.append(this.formatter.format(event, this.overridenPattern, this.noColor));
            } else if (event != null && this.logger == null) {
                out.append(this.formatter.format(event, this.overridenPattern, this.noColor));
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

