/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.shell.support.completers.CommandsCompleter;

@Command(scope="shell", name="watch", description="Watches & refreshes the output of a command")
@Service
public class WatchAction
implements Action {
    @Option(name="-n", aliases={"--interval"}, description="The interval between executions of the command in seconds", required=false, multiValued=false)
    private long interval = 1L;
    @Option(name="-a", aliases={"--append"}, description="The output should be appended but not clear the console", required=false, multiValued=false)
    private boolean append = false;
    @Argument(index=0, name="command", description="The command to watch / refresh", required=true, multiValued=true)
    @Completion(value=CommandsCompleter.class)
    private String[] arguments;
    @Reference
    Session session;
    @Reference
    SessionFactory sessionFactory;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        if (this.arguments == null || this.arguments.length == 0) {
            System.err.println("Argument expected");
        } else {
            StringBuilder command = new StringBuilder();
            for (String arg : this.arguments) {
                command.append(arg).append(" ");
            }
            WatchTask watchTask = new WatchTask(command.toString().trim());
            this.executorService.scheduleAtFixedRate(watchTask, 0L, this.interval, TimeUnit.SECONDS);
            try {
                this.session.getKeyboard().read();
                watchTask.abort();
            }
            finally {
                this.executorService.shutdownNow();
                watchTask.close();
            }
        }
        return null;
    }

    public class WatchTask
    implements Runnable {
        private final String command;
        Session session;
        ByteArrayOutputStream byteArrayOutputStream = null;
        PrintStream printStream = null;
        boolean doDisplay = true;

        public WatchTask(String command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.byteArrayOutputStream = new ByteArrayOutputStream();
                this.printStream = new PrintStream(this.byteArrayOutputStream);
                this.session = WatchAction.this.sessionFactory.create(null, this.printStream, this.printStream, WatchAction.this.session);
                String output = "";
                try {
                    this.session.execute((CharSequence)this.command);
                }
                catch (Exception e) {
                    ShellUtil.logException((Session)this.session, (Throwable)e);
                }
                output = this.byteArrayOutputStream.toString();
                if (this.doDisplay) {
                    if (!WatchAction.this.append) {
                        System.out.print("\u001b[2J");
                        System.out.print("\u001b[1;1H");
                    }
                    System.out.print(output);
                    System.out.flush();
                }
                this.byteArrayOutputStream.close();
                this.session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void abort() {
            this.doDisplay = false;
        }

        public void close() throws IOException {
            if (this.session != null) {
                this.session.close();
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.close();
            }
            if (this.printStream != null) {
                this.printStream.close();
            }
        }
    }
}

