/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.editor;

import org.jledit.ConsoleEditor;
import org.jledit.command.Command;

public class GoToCommand
implements Command {
    private final ConsoleEditor editor;
    private final int line;
    private final int column;

    public GoToCommand(ConsoleEditor editor) {
        this(editor, 0, 0);
    }

    public GoToCommand(ConsoleEditor editor, int line, int column) {
        this.editor = editor;
        this.line = line;
        this.column = column;
    }

    @Override
    public void execute() {
        if (this.line == 0 || this.column == 0) {
            try {
                int targetLine = 1;
                int targetColumn = 1;
                String[] coords = this.editor.readLine("Go to:").split(",");
                if (coords.length == 1) {
                    targetLine = Integer.parseInt(coords[0]);
                } else if (coords.length == 2) {
                    targetLine = Integer.parseInt(coords[0]);
                    targetColumn = Integer.parseInt(coords[1]);
                }
                this.editor.move(targetLine, targetColumn);
            }
            catch (Exception exception) {}
        } else {
            this.editor.move(this.line, this.column);
        }
    }
}

