/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.model;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.karaf.features.ConfigInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="config", propOrder={"value"})
public class Config
implements ConfigInfo {
    @XmlValue
    protected String value;
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute(required=false)
    private Boolean append = false;

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public Properties getProperties() {
        StringReader propStream = new StringReader(this.getValue());
        Properties props = new Properties();
        try {
            props.load(propStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.interpolation(props);
        return props;
    }

    private void interpolation(Properties properties) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = properties.getProperty(key);
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(val);
            while (matcher.find()) {
                String rep = System.getProperty(matcher.group(1));
                if (rep == null) continue;
                val = val.replace(matcher.group(0), rep);
                matcher.reset(val);
            }
            properties.put(key, val);
        }
    }
}

