/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.jceks;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCEKSSecureCredentialsVault
implements SecureCredentialsVault {
    public static final Logger LOG = LoggerFactory.getLogger(JCEKSSecureCredentialsVault.class);
    private final KeyStore m_keystore;
    private final File m_keystoreFile;
    private final char[] m_password;
    private final byte[] m_salt;
    private final int m_iterationCount;
    private final int m_keyLength;

    public JCEKSSecureCredentialsVault(String keystoreFile, String password) {
        this(keystoreFile, password, new byte[]{0, 13, 13, 11, 10, 1, 1});
    }

    public JCEKSSecureCredentialsVault(String keystoreFile, String password, byte[] salt) {
        this(keystoreFile, password, salt, 16, 4096);
    }

    public JCEKSSecureCredentialsVault(String keystoreFile, String password, byte[] salt, int iterationCount, int keyLength) {
        block15: {
            this.m_password = Objects.requireNonNull(password).toCharArray();
            this.m_salt = Objects.requireNonNull(salt);
            this.m_iterationCount = iterationCount;
            this.m_keyLength = keyLength;
            this.m_keystoreFile = new File(keystoreFile);
            try {
                this.m_keystore = KeyStore.getInstance("JCEKS");
                if (!this.m_keystoreFile.isFile()) {
                    LOG.info("No existing keystore found at: {}. Using empty keystore.");
                    this.m_keystore.load(null, this.m_password);
                    break block15;
                }
                LOG.info("Loading existing keystore from: {}", (Object)this.m_keystoreFile);
                try (FileInputStream is = new FileInputStream(this.m_keystoreFile);){
                    this.m_keystore.load(is, this.m_password);
                }
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public Credentials getCredentials(String alias) {
        try {
            KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.m_password);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)this.m_keystore.getEntry(alias, keyStorePP);
            if (ske == null) {
                return null;
            }
            PBEKeySpec keySpec = (PBEKeySpec)factory.getKeySpec(ske.getSecretKey(), PBEKeySpec.class);
            return (Credentials)JCEKSSecureCredentialsVault.fromBase64EncodedByteArray(new String(keySpec.getPassword()).getBytes());
        }
        catch (IOException | ClassNotFoundException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | InvalidKeySpecException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void setCredentials(String alias, Credentials credentials) {
        try {
            byte[] credentialBytes = JCEKSSecureCredentialsVault.toBase64EncodedByteArray((Serializable)credentials);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            SecretKey generatedSecret = factory.generateSecret(new PBEKeySpec(new String(credentialBytes).toCharArray(), this.m_salt, this.m_iterationCount, this.m_keyLength));
            KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.m_password);
            this.m_keystore.setEntry(alias, new KeyStore.SecretKeyEntry(generatedSecret), keyStorePP);
            this.writeKeystoreToDisk();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void writeKeystoreToDisk() {
        try (FileOutputStream os = new FileOutputStream(this.m_keystoreFile);){
            this.m_keystore.store(os, this.m_password);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static byte[] toBase64EncodedByteArray(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(o);
        out.close();
        return Base64.encodeBase64((byte[])baos.toByteArray());
    }

    private static <T extends Serializable> T fromBase64EncodedByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        byte[] decodedBytes = Base64.decodeBase64((byte[])bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(decodedBytes);
        ObjectInputStream in = new ObjectInputStream(bais);
        Serializable o = (Serializable)in.readObject();
        in.close();
        return (T)o;
    }

    public Set<String> getAliases() {
        try {
            return Sets.newHashSet(Collections.list(this.m_keystore.aliases()));
        }
        catch (KeyStoreException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

