/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

public class DeprecatedBeanWarner
implements BeanFactoryPostProcessor {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void setLoggerName(String loggerName) {
        this.logger = LogFactory.getLog((String)loggerName);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.isLogEnabled()) {
            String[] beanNames;
            String[] stringArray = beanNames = beanFactory.getBeanDefinitionNames();
            int n = beanNames.length;
            int n2 = 0;
            while (n2 < n) {
                String beanName = stringArray[n2];
                Class<?> beanType = beanFactory.getType(beanName);
                if (beanType != null && beanType.isAnnotationPresent(Deprecated.class)) {
                    BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                    this.logDeprecatedBean(beanName, beanDefinition);
                }
                ++n2;
            }
        }
    }

    protected void logDeprecatedBean(String beanName, BeanDefinition beanDefinition) {
        StringBuilder builder = new StringBuilder();
        builder.append(beanDefinition.getBeanClassName());
        builder.append(" ['");
        builder.append(beanName);
        builder.append('\'');
        String resourceDescription = beanDefinition.getResourceDescription();
        if (StringUtils.hasLength((String)resourceDescription)) {
            builder.append(" in ");
            builder.append(resourceDescription);
        }
        builder.append(" ] has been deprecated");
        this.logger.warn((Object)builder.toString());
    }

    protected boolean isLogEnabled() {
        return this.logger.isWarnEnabled();
    }
}

