/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.impl.jline;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

class DelayedStarted
extends Thread
implements FrameworkListener {
    private static final String SYSTEM_PROP_KARAF_CONSOLE_STARTED = "karaf.console.started";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final InputStream in;
    private final Runnable console;
    private final BundleContext bundleContext;

    DelayedStarted(Runnable console, String name, BundleContext bundleContext, InputStream in) {
        super(name);
        this.console = console;
        this.bundleContext = bundleContext;
        this.in = in;
        int defaultStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
        int startLevel = ((FrameworkStartLevel)bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class)).getStartLevel();
        if (startLevel >= defaultStartLevel) {
            this.started.set(true);
        } else {
            bundleContext.addFrameworkListener((FrameworkListener)this);
            this.frameworkEvent(new FrameworkEvent(8, bundleContext.getBundle(), null));
        }
    }

    @Override
    public void run() {
        try {
            block2: while (!this.started.get()) {
                if (this.in.available() == 0) {
                    Thread.sleep(10L);
                }
                while (this.in.available() > 0) {
                    char ch = (char)this.in.read();
                    if (ch != '\r' && ch != '\n') continue;
                    this.started.set(true);
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.setProperty(SYSTEM_PROP_KARAF_CONSOLE_STARTED, "true");
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        this.console.run();
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8) {
            int defaultStartLevel = Integer.parseInt(System.getProperty("org.osgi.framework.startlevel.beginning"));
            int startLevel = ((FrameworkStartLevel)this.bundleContext.getBundle(0L).adapt(FrameworkStartLevel.class)).getStartLevel();
            if (startLevel >= defaultStartLevel) {
                this.started.set(true);
            }
        }
    }
}

