/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.karaf.util.process.StreamPumper;

public class PumpStreamHandler {
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final String name;
    private StreamPumper outputPump;
    private StreamPumper errorPump;
    private StreamPumper inputPump;

    public PumpStreamHandler(InputStream in, OutputStream out, OutputStream err, String name) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        assert (name != null);
        this.in = in;
        this.out = out;
        this.err = err;
        this.name = name;
    }

    public PumpStreamHandler(InputStream in, OutputStream out, OutputStream err) {
        this(in, out, err, "<unknown>");
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(null, out, err);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public void setChildOutputStream(InputStream in) {
        assert (in != null);
        this.createChildOutputPump(in, this.out);
    }

    public void setChildErrorStream(InputStream in) {
        assert (in != null);
        if (this.err != null) {
            this.createChildErrorPump(in, this.err);
        }
    }

    public void setChildInputStream(OutputStream out) {
        assert (out != null);
        if (this.in != null) {
            this.inputPump = this.createInputPump(this.in, out, true);
        } else {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void attach(Process p) {
        assert (p != null);
        this.setChildInputStream(p.getOutputStream());
        this.setChildOutputStream(p.getInputStream());
        this.setChildErrorStream(p.getErrorStream());
    }

    public void start() {
        Thread thread;
        if (this.outputPump != null) {
            thread = new Thread(this.outputPump);
            thread.setDaemon(true);
            thread.setName("Output pump for " + this.name);
            thread.start();
        }
        if (this.errorPump != null) {
            thread = new Thread(this.errorPump);
            thread.setDaemon(true);
            thread.setName("Error pump for " + this.name);
            thread.start();
        }
        if (this.inputPump != null) {
            thread = new Thread(this.inputPump);
            thread.setDaemon(true);
            thread.setName("Input pump for " + this.name);
            thread.start();
        }
    }

    public void stop() {
        if (this.outputPump != null) {
            try {
                this.outputPump.stop();
                this.outputPump.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.outputPump.getIn().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.errorPump != null) {
            try {
                this.errorPump.stop();
                this.errorPump.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.errorPump.getIn().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.inputPump != null) {
            this.inputPump.stop();
            try {
                this.inputPump.getOut().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void createChildOutputPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        this.outputPump = this.createPump(in, out);
    }

    protected void createChildErrorPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        this.errorPump = this.createPump(in, out);
    }

    protected StreamPumper createPump(InputStream in, OutputStream out) {
        assert (in != null);
        assert (out != null);
        return this.createPump(in, out, false);
    }

    protected StreamPumper createPump(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        StreamPumper pumper = new StreamPumper(in, out, closeWhenExhausted);
        return pumper;
    }

    protected StreamPumper createInputPump(InputStream in, OutputStream out, boolean closeWhenExhausted) {
        assert (in != null);
        assert (out != null);
        StreamPumper pumper = new StreamPumper(in, out, closeWhenExhausted);
        pumper.setNonBlocking(true);
        pumper.setAutoflush(true);
        return pumper;
    }

    public StreamPumper getOutputPump() {
        return this.outputPump;
    }

    public StreamPumper getErrorPump() {
        return this.errorPump;
    }
}

