/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveDictionary
extends Dictionary<String, Object> {
    private SortedMap<String, Object> internalMap;
    private static final Set<Class> KNOWN = new HashSet<Class>(Arrays.asList(String.class, Integer.class, Long.class, Float.class, Double.class, Byte.class, Short.class, Character.class, Boolean.class));
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public CaseInsensitiveDictionary() {
        this.internalMap = new TreeMap<String, Object>(CASE_INSENSITIVE_ORDER);
    }

    public CaseInsensitiveDictionary(Dictionary props) {
        if (props instanceof CaseInsensitiveDictionary) {
            this.internalMap = new TreeMap<String, Object>(((CaseInsensitiveDictionary)props).internalMap);
        } else if (props != null) {
            this.internalMap = new TreeMap<String, Object>(CASE_INSENSITIVE_ORDER);
            Enumeration keys = props.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                String k = CaseInsensitiveDictionary.checkKey(key);
                if (this.internalMap.containsKey(k)) {
                    throw new IllegalArgumentException("Key [" + key + "] already present in different case");
                }
                Object value = props.get(key);
                value = CaseInsensitiveDictionary.checkValue(value);
                this.internalMap.put(k, value);
            }
        } else {
            this.internalMap = new TreeMap<String, Object>(CASE_INSENSITIVE_ORDER);
        }
    }

    CaseInsensitiveDictionary(CaseInsensitiveDictionary props, boolean deepCopy) {
        if (deepCopy) {
            this.internalMap = new TreeMap<String, Object>(CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, Object> entry : props.internalMap.entrySet()) {
                Vector value = entry.getValue();
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    Object newValue = Array.newInstance(value.getClass().getComponentType(), length);
                    System.arraycopy(value, 0, newValue, 0, length);
                    value = newValue;
                } else if (value instanceof Collection) {
                    value = new Vector(value);
                }
                this.internalMap.put(entry.getKey(), value);
            }
        } else {
            this.internalMap = new TreeMap<String, Object>(props.internalMap);
        }
    }

    @Override
    public Enumeration<Object> elements() {
        return Collections.enumeration(this.internalMap.values());
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.internalMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return Collections.enumeration(this.internalMap.keySet());
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("key or value");
        }
        CaseInsensitiveDictionary.checkKey(key);
        value = CaseInsensitiveDictionary.checkValue(value);
        return this.internalMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.internalMap.remove(key);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    static String checkKey(Object keyObject) {
        if (!(keyObject instanceof String)) {
            throw new IllegalArgumentException("Key [" + keyObject + "] must be a String");
        }
        String key = (String)keyObject;
        if (key.length() == 0) {
            throw new IllegalArgumentException("Key [" + key + "] must not be an empty string");
        }
        return key;
    }

    static Object checkValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        Class<?> type = value.getClass();
        if (KNOWN.contains(type)) {
            return value;
        }
        if (type.isArray()) {
            type = value.getClass().getComponentType();
            if (type.isPrimitive()) {
                return value;
            }
        } else if (value instanceof Collection) {
            Collection collection = value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Collection must not be empty");
            }
            ArrayList internalValue = new ArrayList(collection.size());
            type = null;
            for (Object el : collection) {
                if (el == null) {
                    throw new IllegalArgumentException("Collection must not contain null elements");
                }
                if (type == null) {
                    type = el.getClass();
                } else if (type != el.getClass()) {
                    throw new IllegalArgumentException("Collection element types must not be mixed");
                }
                internalValue.add(el);
            }
            value = internalValue;
        } else {
            type = value.getClass();
        }
        if (KNOWN.contains(type)) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] has unsupported (base-) type " + type);
    }

    public String toString() {
        return this.internalMap.toString();
    }

    private static char toLowerCaseFast(char ch) {
        return ch >= 'A' && ch <= 'Z' ? (char)(ch + 97 - 65) : ch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseInsensitiveComparator
    implements Comparator<String> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int n2;
            int n1 = s1.length();
            int min = n1 < (n2 = s2.length()) ? n1 : n2;
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || !(c1 <= '\u0080' && c2 <= '\u0080' ? (c1 = CaseInsensitiveDictionary.toLowerCaseFast(c1)) != (c2 = CaseInsensitiveDictionary.toLowerCaseFast(c2)) : (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2)))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }
    }
}

