/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUserAuthServiceOld
extends CloseableUtils.AbstractCloseable
implements Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private UserAuth userAuth;
    private volatile AuthFuture authFuture;
    protected final ClientSessionImpl session;
    protected final Object lock;

    public ClientUserAuthServiceOld(Session s) {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Client side service used on server side");
        }
        this.session = (ClientSessionImpl)s;
        this.lock = this.session.getLock();
        this.authFuture = new DefaultAuthFuture(this.lock);
    }

    public ClientSessionImpl getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.log.debug("accepted");
            this.authFuture.setAuthed(false);
        }
    }

    public void process(byte cmd, Buffer buffer) throws Exception {
        if (this.authFuture.isSuccess()) {
            throw new IllegalStateException("UserAuth message delivered to authenticated client");
        }
        if (this.authFuture.isDone()) {
            this.log.debug("Ignoring random message");
        } else if (cmd == 53) {
            String welcome = buffer.getString();
            String lang = buffer.getString();
            this.log.debug("Welcome banner: {}", (Object)welcome);
            UserInteraction ui = this.session.getFactoryManager().getUserInteraction();
            if (ui != null) {
                ui.welcome(welcome);
            }
        } else {
            buffer.rpos(buffer.rpos() - 1);
            this.processUserAuth(buffer);
        }
    }

    private boolean readyForAuth(UserAuth userAuth) {
        while (!this.authFuture.isDone()) {
            this.log.debug("waiting to send authentication");
            try {
                this.authFuture.await();
            }
            catch (InterruptedException e) {
                this.log.debug("Unexpected interrupt", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.authFuture.isSuccess()) {
            this.log.debug("already authenticated");
            throw new IllegalStateException("Already authenticated");
        }
        if (this.authFuture.getException() != null) {
            this.log.debug("probably closed", this.authFuture.getException());
            return false;
        }
        if (!this.authFuture.isFailure()) {
            this.log.debug("unexpected state");
            throw new IllegalStateException("Unexpected authentication state");
        }
        if (this.userAuth != null) {
            this.log.debug("authentication already in progress");
            throw new IllegalStateException("Authentication already in progress?");
        }
        this.userAuth = userAuth;
        this.authFuture = new DefaultAuthFuture(this.lock);
        this.log.debug("ready to try authentication with new lock");
        return true;
    }

    private void processUserAuth(Buffer buffer) throws IOException {
        this.log.debug("processing {}", (Object)this.userAuth);
        switch (this.userAuth.next(buffer)) {
            case Success: {
                this.log.debug("succeeded with {}", (Object)this.userAuth);
                this.session.setAuthenticated();
                this.session.switchToNextService();
                this.authFuture.setAuthed(true);
                break;
            }
            case Failure: {
                this.log.debug("failed with {}", (Object)this.userAuth);
                this.userAuth = null;
                this.authFuture.setAuthed(false);
                break;
            }
            case Continued: {
                this.log.debug("continuing with {}", (Object)this.userAuth);
            }
        }
    }

    protected void preClose() {
        super.preClose();
        if (!this.authFuture.isDone()) {
            this.authFuture.setException(new SshException("Session is closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthFuture auth(UserAuth userAuth) throws IOException {
        this.log.debug("Trying authentication with {}", (Object)userAuth);
        Object object = this.lock;
        synchronized (object) {
            if (this.readyForAuth(userAuth)) {
                this.processUserAuth(null);
            }
            return this.authFuture;
        }
    }
}

