/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.impl.jline;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Terminal;
import jline.UnsupportedTerminal;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.console.history.PersistentHistory;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.console.CloseShellException;
import org.apache.karaf.shell.console.CommandSessionHolder;
import org.apache.karaf.shell.console.Console;
import org.apache.karaf.shell.console.completer.CommandsCompleter;
import org.apache.karaf.shell.console.impl.jline.Branding;
import org.apache.karaf.shell.console.impl.jline.CompleterAsCompletor;
import org.apache.karaf.shell.console.impl.jline.KarafFileHistory;
import org.apache.karaf.shell.security.impl.SecuredCommandProcessorImpl;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleImpl
implements Console {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String SHELL_HISTORY_MAXSIZE = "karaf.shell.history.maxSize";
    public static final String PROMPT = "PROMPT";
    public static final String DEFAULT_PROMPT = "\u001b[1m${USER}\u001b[0m@${APPLICATION}(${SUBSHELL})> ";
    private static final Logger LOGGER = LoggerFactory.getLogger(Console.class);
    protected CommandSession session;
    protected ThreadIO threadIO;
    private ConsoleReader reader;
    private BlockingQueue<Integer> queue;
    private boolean interrupt;
    private Thread pipe;
    private volatile boolean running;
    private volatile boolean eof;
    private Runnable closeCallback;
    private Terminal terminal;
    private InputStream consoleInput;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private boolean secured;
    private Thread thread;
    private final BundleContext bundleContext;
    private CommandsCompleter completer;

    public ConsoleImpl(CommandProcessor processor, ThreadIO threadIO, InputStream in, PrintStream out, PrintStream err, Terminal term, String encoding, Runnable closeCallback, BundleContext bc, boolean secured) {
        String maxSizeStr;
        this.threadIO = threadIO;
        this.in = in;
        this.out = out;
        this.err = err;
        this.secured = secured;
        this.queue = new ArrayBlockingQueue<Integer>(1024);
        this.terminal = term == null ? new UnsupportedTerminal() : term;
        this.consoleInput = new ConsoleInputStream();
        this.session = secured ? new DelegateSession() : processor.createSession(this.consoleInput, out, err);
        this.session.put("SCOPE", "shell:bundle:*");
        this.session.put("SUBSHELL", "");
        this.setCompletionMode();
        this.closeCallback = closeCallback;
        this.bundleContext = bc;
        try {
            this.reader = new ConsoleReader(null, this.consoleInput, (OutputStream)this.out, this.terminal, encoding);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening console reader", e);
        }
        File file = this.getHistoryFile();
        try {
            file.getParentFile().mkdirs();
            this.reader.setHistory((History)new KarafFileHistory(file));
        }
        catch (Exception e) {
            LOGGER.error("Can not read history from file " + file + ". Using in memory history", (Throwable)e);
        }
        if (this.reader != null && this.reader.getHistory() instanceof MemoryHistory && (maxSizeStr = System.getProperty(SHELL_HISTORY_MAXSIZE)) != null) {
            ((MemoryHistory)this.reader.getHistory()).setMaxSize(Integer.parseInt(maxSizeStr));
        }
        this.session.put(".jline.reader", this.reader);
        this.session.put(".jline.history", this.reader.getHistory());
        this.completer = this.createCompleter();
        if (this.completer != null) {
            this.reader.addCompleter((Completer)new CompleterAsCompletor(this.completer));
        }
        this.pipe = new Thread(new Pipe());
        this.pipe.setName("gogo shell pipe thread");
        this.pipe.setDaemon(true);
    }

    protected File getHistoryFile() {
        String defaultHistoryPath = new File(System.getProperty("user.home"), ".karaf/karaf.history").toString();
        return new File(System.getProperty("karaf.history", defaultHistoryPath));
    }

    public boolean isSecured() {
        return this.secured;
    }

    @Override
    public CommandSession getSession() {
        return this.session;
    }

    @Override
    public void close(boolean closedByUser) {
        if (!this.running) {
            return;
        }
        if (this.reader.getHistory() instanceof PersistentHistory) {
            try {
                ((PersistentHistory)this.reader.getHistory()).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.running = false;
        CommandSessionHolder.unset();
        this.pipe.interrupt();
        this.completer.dispose();
        if (closedByUser && this.closeCallback != null) {
            this.closeCallback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.threadIO.setStreams(this.consoleInput, this.out, this.err);
            SecuredCommandProcessorImpl secCP = null;
            if (this.secured) {
                secCP = this.createSecuredCommandProcessor();
            }
            this.thread = Thread.currentThread();
            CommandSessionHolder.setSession(this.session);
            this.running = true;
            this.pipe.start();
            Properties brandingProps = Branding.loadBrandingProperties(this.terminal);
            this.welcome(brandingProps);
            this.setSessionProperties(brandingProps);
            String scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
            this.executeScript(scriptFileName);
            while (this.running) {
                try {
                    String command = this.readAndParseCommand();
                    if (command == null) break;
                    Object result = this.session.execute(command);
                    if (result == null) continue;
                    this.session.getConsole().println(this.session.format(result, 0));
                }
                catch (InterruptedIOException command) {
                }
                catch (InterruptedException command) {
                }
                catch (CloseShellException e) {
                    break;
                }
                catch (Throwable t) {
                    ShellUtil.logException(this.session, t);
                }
            }
            if (this.secured) {
                try {
                    secCP.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.close(true);
        }
        finally {
            try {
                this.threadIO.close();
            }
            catch (Throwable throwable) {}
        }
    }

    SecuredCommandProcessorImpl createSecuredCommandProcessor() {
        if (!(this.session instanceof DelegateSession)) {
            throw new IllegalStateException("Should be an Delegate Session here, about to set the delegate");
        }
        DelegateSession is = (DelegateSession)this.session;
        SecuredCommandProcessorImpl secCP = new SecuredCommandProcessorImpl(this.bundleContext);
        CommandSession s = secCP.createSession(this.consoleInput, this.out, this.err);
        is.setDelegate(s);
        return secCP;
    }

    private void setCompletionMode() {
        try {
            File shellCfg = new File(System.getProperty("karaf.etc"), "/org.apache.karaf.shell.cfg");
            Properties properties = new Properties();
            properties.load(new FileInputStream(shellCfg));
            if (properties.get("completionMode") != null) {
                this.session.put("karaf.completionMode", properties.get("completionMode"));
            } else {
                LOGGER.debug("completionMode property is not defined in etc/org.apache.karaf.shell.cfg file. Using default completion mode.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't read {}/org.apache.karaf.shell.cfg file. The completion is set to default.", (Object)System.getProperty("karaf.etc"));
        }
    }

    private String readAndParseCommand() throws IOException {
        String command = null;
        boolean loop = true;
        boolean first = true;
        while (loop) {
            this.checkInterrupt();
            String line = this.reader.readLine(first ? this.getPrompt() : "> ");
            if (line == null) break;
            command = command == null ? line : (command.charAt(command.length() - 1) == '\\' ? command.substring(0, command.length() - 1) + line : command + "\n" + line);
            if (this.reader.getHistory().size() == 0) {
                this.reader.getHistory().add((CharSequence)command);
            } else if (command.length() > 0 && !" ".equals(command)) {
                this.reader.getHistory().replace((CharSequence)command);
            }
            if (command.length() > 0 && command.charAt(command.length() - 1) == '\\') {
                loop = true;
                first = false;
                continue;
            }
            try {
                Class<?> cl = CommandSession.class.getClassLoader().loadClass("org.apache.felix.gogo.runtime.Parser");
                Object parser = cl.getConstructor(CharSequence.class).newInstance(command);
                cl.getMethod("program", new Class[0]).invoke(parser, new Object[0]);
                loop = false;
            }
            catch (Exception e) {
                loop = true;
                first = false;
            }
            catch (Throwable t) {
                loop = false;
            }
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String scriptFileName) {
        if (scriptFileName != null) {
            Reader r = null;
            try {
                int n;
                File scriptFile = new File(scriptFileName);
                r = new InputStreamReader(new FileInputStream(scriptFile));
                CharArrayWriter w = new CharArrayWriter();
                char[] buf = new char[8192];
                while ((n = r.read(buf)) > 0) {
                    w.write(buf, 0, n);
                }
                this.session.execute(new String(w.toCharArray()));
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script", (Throwable)e);
                System.err.println("Error in initialization script: " + e.getMessage());
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void welcome(Properties brandingProps) {
        String welcome = brandingProps.getProperty("welcome");
        if (welcome != null && welcome.length() > 0) {
            this.session.getConsole().println(welcome);
        }
    }

    protected void setSessionProperties(Properties brandingProps) {
        for (Map.Entry<Object, Object> entry : brandingProps.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("session.")) continue;
            this.session.put(key.substring("session.".length()), entry.getValue());
        }
    }

    protected CommandsCompleter createCompleter() {
        return new CommandsCompleter(this.session);
    }

    protected String getPrompt() {
        try {
            String prompt;
            try {
                Object p = this.session.get(PROMPT);
                if (p != null) {
                    prompt = p.toString();
                } else {
                    Properties properties = Branding.loadBrandingProperties(this.terminal);
                    if (properties.getProperty("prompt") != null) {
                        prompt = properties.getProperty("prompt");
                        this.session.put(PROMPT, prompt);
                    } else {
                        prompt = DEFAULT_PROMPT;
                    }
                }
            }
            catch (Throwable t) {
                prompt = DEFAULT_PROMPT;
            }
            Matcher matcher = Pattern.compile("\\$\\{([^}]+)\\}").matcher(prompt);
            while (matcher.find()) {
                Object rep = this.session.get(matcher.group(1));
                if (rep == null) continue;
                prompt = prompt.replace(matcher.group(0), rep.toString());
                matcher.reset(prompt);
            }
            return prompt;
        }
        catch (Throwable t) {
            return "$ ";
        }
    }

    private void checkInterrupt() throws IOException {
        if (Thread.interrupted() || this.interrupt) {
            this.interrupt = false;
            throw new InterruptedIOException("Keyboard interruption");
        }
    }

    private void interrupt() {
        this.interrupt = true;
        this.thread.interrupt();
    }

    static /* synthetic */ InputStream access$600(ConsoleImpl x0) {
        return x0.in;
    }

    static /* synthetic */ PrintStream access$700(ConsoleImpl x0) {
        return x0.err;
    }

    static /* synthetic */ void access$800(ConsoleImpl x0) {
        x0.interrupt();
    }

    static /* synthetic */ ConsoleReader access$900(ConsoleImpl x0) {
        return x0.reader;
    }

    static /* synthetic */ boolean access$402(ConsoleImpl x0, boolean x1) {
        x0.eof = x1;
        return x0.eof;
    }

    static class DelegateSession
    implements CommandSession {
        final Map<String, Object> attrs = new HashMap<String, Object>();
        volatile CommandSession delegate;

        DelegateSession() {
        }

        @Override
        public Object execute(CharSequence commandline) throws Exception {
            if (this.delegate != null) {
                return this.delegate.execute(commandline);
            }
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDelegate(CommandSession s) {
            DelegateSession delegateSession = this;
            synchronized (delegateSession) {
                for (Map.Entry<String, Object> entry : this.attrs.entrySet()) {
                    s.put(entry.getKey(), entry.getValue());
                }
            }
            this.delegate = s;
        }

        @Override
        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        @Override
        public InputStream getKeyboard() {
            if (this.delegate != null) {
                return this.delegate.getKeyboard();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public PrintStream getConsole() {
            if (this.delegate != null) {
                return this.delegate.getConsole();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(String name) {
            if (this.delegate != null) {
                return this.delegate.get(name);
            }
            return this.attrs.get(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(String name, Object value) {
            if (this.delegate != null) {
                this.delegate.put(name, value);
                return;
            }
            DelegateSession delegateSession = this;
            synchronized (delegateSession) {
                this.attrs.put(name, value);
            }
        }

        @Override
        public CharSequence format(Object target, int level) {
            if (this.delegate != null) {
                return this.delegate.format(target, level);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public Object convert(Class<?> type, Object instance) {
            if (this.delegate != null) {
                return this.delegate.convert(type, instance);
            }
            throw new UnsupportedOperationException();
        }
    }

    private class Pipe
    implements Runnable {
        private Pipe() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                block20: {
                    try {
                        if (!ConsoleImpl.access$200(ConsoleImpl.this)) break;
                        try {
                            c = ConsoleImpl.access$600(ConsoleImpl.this).read();
                            if (c == -1) {
                                break block20;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable t) {
                            ConsoleImpl.access$402(ConsoleImpl.this, true);
                            try {
                                ConsoleImpl.access$500(ConsoleImpl.this).put(-1);
                                return;
                            }
                            catch (InterruptedException var2_6) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    catch (Throwable var3_7) {
                        ConsoleImpl.access$402(ConsoleImpl.this, true);
                        try {
                            ConsoleImpl.access$500(ConsoleImpl.this).put(-1);
                            throw var3_7;
                        }
                        catch (InterruptedException var4_8) {
                            // empty catch block
                        }
                        throw var3_7;
                    }
                }
                ConsoleImpl.access$402(ConsoleImpl.this, true);
                try {
                    ConsoleImpl.access$500(ConsoleImpl.this).put(-1);
                    return;
                }
                catch (InterruptedException var2_4) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    if (c != 4 || ShellUtil.getBoolean(ConsoleImpl.this.session, "karaf.ignoreInterrupts")) ** GOTO lbl-1000
                    ConsoleImpl.access$700(ConsoleImpl.this).println("^D");
                    ConsoleImpl.access$800(ConsoleImpl.this);
                }
                ConsoleImpl.access$402(ConsoleImpl.this, true);
                try {
                    ConsoleImpl.access$500(ConsoleImpl.this).put(-1);
                    return;
                }
                catch (InterruptedException var2_5) {
                    // empty catch block
                }
                return;
lbl-1000:
                // 1 sources

                {
                    if (c == 3 && !ShellUtil.getBoolean(ConsoleImpl.this.session, "karaf.ignoreInterrupts")) {
                        ConsoleImpl.access$700(ConsoleImpl.this).println("^C");
                        ConsoleImpl.access$900(ConsoleImpl.this).getCursorBuffer().clear();
                        ConsoleImpl.access$800(ConsoleImpl.this);
                    }
                    ConsoleImpl.access$500(ConsoleImpl.this).put(c);
                    continue;
                }
                break;
            }
            ConsoleImpl.access$402(ConsoleImpl.this, true);
            try {
                ConsoleImpl.access$500(ConsoleImpl.this).put(-1);
                return;
            }
            catch (InterruptedException var1_3) {
                return;
            }
        }
    }

    private class ConsoleInputStream
    extends InputStream {
        private ConsoleInputStream() {
        }

        private int read(boolean wait) throws IOException {
            Integer i;
            if (!ConsoleImpl.this.running) {
                return -1;
            }
            ConsoleImpl.this.checkInterrupt();
            if (ConsoleImpl.this.eof && ConsoleImpl.this.queue.isEmpty()) {
                return -1;
            }
            if (wait) {
                try {
                    i = (Integer)ConsoleImpl.this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                ConsoleImpl.this.checkInterrupt();
            } else {
                i = (Integer)ConsoleImpl.this.queue.poll();
            }
            if (i == null) {
                return -1;
            }
            return i;
        }

        @Override
        public int read() throws IOException {
            return this.read(true);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int nb;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int i = this.read(true);
            if (i < 0) {
                return -1;
            }
            b[off++] = (byte)i;
            for (nb = 1; nb < len; ++nb) {
                i = this.read(false);
                if (i < 0) {
                    return nb;
                }
                b[off++] = (byte)i;
            }
            return nb;
        }

        @Override
        public int available() throws IOException {
            return ConsoleImpl.this.queue.size();
        }
    }
}

