/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.util.Comparator;
import java.util.Set;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class CandidateComparator
implements Comparator<Capability> {
    private final Set<Resource> mandatory;

    public CandidateComparator(Set<Resource> mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public int compare(Capability cap1, Capability cap2) {
        Version v2;
        Version v1;
        int c = 0;
        if (cap1 instanceof BundleCapability && !(cap2 instanceof BundleCapability)) {
            c = -1;
        } else if (!(cap1 instanceof BundleCapability) && cap2 instanceof BundleCapability) {
            c = 1;
        }
        if (c == 0) {
            if (this.mandatory.contains(cap1.getResource()) && !this.mandatory.contains(cap2.getResource())) {
                c = -1;
            } else if (!this.mandatory.contains(cap1.getResource()) && this.mandatory.contains(cap2.getResource())) {
                c = 1;
            }
        }
        if (c == 0 && cap1.getNamespace().equals("osgi.wiring.bundle")) {
            c = ((Comparable)cap1.getAttributes().get("osgi.wiring.bundle")).compareTo(cap2.getAttributes().get("osgi.wiring.bundle"));
            if (c == 0) {
                v1 = !cap1.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("bundle-version");
                v2 = !cap2.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("bundle-version");
                c = this.compareVersions(v2, v1);
            }
        } else if (c == 0 && cap1.getNamespace().equals("osgi.wiring.package")) {
            c = ((Comparable)cap1.getAttributes().get("osgi.wiring.package")).compareTo(cap2.getAttributes().get("osgi.wiring.package"));
            if (c == 0) {
                v1 = !cap1.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("version");
                v2 = !cap2.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("version");
                c = this.compareVersions(v2, v1);
                if (c == 0) {
                    v1 = !cap1.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("bundle-version");
                    v2 = !cap2.getAttributes().containsKey("bundle-version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("bundle-version");
                    c = this.compareVersions(v2, v1);
                }
            }
        } else if (c == 0 && cap1.getNamespace().equals("osgi.identity") && (c = ((Comparable)cap1.getAttributes().get("osgi.identity")).compareTo(cap2.getAttributes().get("osgi.identity"))) == 0) {
            v1 = !cap1.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap1.getAttributes().get("version");
            v2 = !cap2.getAttributes().containsKey("version") ? Version.emptyVersion : (Version)cap2.getAttributes().get("version");
            c = this.compareVersions(v2, v1);
        }
        if (c == 0) {
            String n1 = ResolverUtil.getSymbolicName(cap1.getResource());
            String n2 = ResolverUtil.getSymbolicName(cap2.getResource());
            c = n1.compareTo(n2);
        }
        return c;
    }

    private int compareVersions(Version v1, Version v2) {
        int c = v1.getMajor() - v2.getMajor();
        if (c != 0) {
            return c;
        }
        c = v1.getMinor() - v2.getMinor();
        if (c != 0) {
            return c;
        }
        c = v1.getMicro() - v2.getMicro();
        if (c != 0) {
            return c;
        }
        return v1.getQualifier().compareTo(v2.getQualifier());
    }
}

