/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="shell", name="threads", description="Prints the current threads (optionally with stacktraces)")
@Service
public class ThreadsAction
implements Action {
    @Option(name="--tree", description="Display threads as a tree")
    boolean tree = false;
    @Option(name="--list", description="Display threads as a list")
    boolean list = false;
    @Option(name="-e", aliases={"--empty-groups"}, description="Show empty groups")
    boolean empty = false;
    @Option(name="-t", aliases={"--threshold"}, description="Minimal number of interesting stack trace line to display a thread")
    int threshold = 1;
    @Option(name="--locks", description="Display locks")
    boolean locks = false;
    @Option(name="--monitors", description="Display monitors")
    boolean monitors = false;
    @Option(name="--packages", description="Pruned packages")
    List<String> packages = Arrays.asList("java.", "sun.");
    @Argument(name="id", description="Show details for thread with this Id", required=false, multiValued=false)
    Long id;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    public Object execute() throws Exception {
        TreeMap<Long, ThreadInfo> threadInfos = new TreeMap<Long, ThreadInfo>();
        ThreadMXBean threadsBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = threadsBean.isObjectMonitorUsageSupported() && threadsBean.isSynchronizerUsageSupported() ? threadsBean.dumpAllThreads(true, true) : threadsBean.getThreadInfo(threadsBean.getAllThreadIds(), Integer.MAX_VALUE);
        for (ThreadInfo info : infos) {
            threadInfos.put(info.getThreadId(), info);
        }
        if (this.id != null) {
            ThreadInfo ti = (ThreadInfo)threadInfos.get(this.id);
            if (ti != null) {
                StackTraceElement[] st;
                System.out.println("Thread " + ti.getThreadId() + " " + ti.getThreadName() + " " + (Object)((Object)ti.getThreadState()));
                System.out.println("Stacktrace:");
                for (StackTraceElement ste : st = ti.getStackTrace()) {
                    System.out.println(ste.getClassName() + "." + ste.getMethodName() + " line: " + ste.getLineNumber());
                }
            }
        } else if (this.list) {
            ShellTable table = new ShellTable();
            table.column("Id");
            table.column("Name");
            table.column("State");
            table.column("CPU time");
            table.column("Usr time");
            for (ThreadInfo thread : threadInfos.values()) {
                long id = thread.getThreadId();
                table.addRow().addContent(new Object[]{id, thread.getThreadName(), thread.getThreadState(), threadsBean.getThreadCpuTime(id) / 1000000L, threadsBean.getThreadUserTime(id) / 1000000L});
            }
            table.print(System.out, !this.noFormat);
        } else {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            while (group.getParent() != null) {
                group = group.getParent();
            }
            ThreadGroupData data = new ThreadGroupData(group, threadInfos);
            data.print();
        }
        return null;
    }

    public class ThreadData {
        private final Thread thread;
        private ThreadInfo info;

        public ThreadData(Thread thread, ThreadInfo info) {
            this.thread = thread;
            this.info = info;
        }

        public void printTree(String indent) {
            System.out.println(indent + "    " + "\"" + this.thread.getName() + "\": " + (Object)((Object)this.thread.getState()));
        }

        public void printDump(String indent) {
            if (this.info != null && this.isInteresting()) {
                this.printThreadInfo("    ");
                if (ThreadsAction.this.locks) {
                    this.printLockInfo("    ");
                }
                if (ThreadsAction.this.monitors) {
                    this.printMonitorInfo("    ");
                }
            }
        }

        public boolean isInteresting() {
            int nb = 0;
            StackTraceElement[] stacktrace = this.info.getStackTrace();
            for (int i = 0; i < stacktrace.length; ++i) {
                StackTraceElement ste = stacktrace[i];
                boolean interestingLine = true;
                for (String pkg : ThreadsAction.this.packages) {
                    if (!ste.getClassName().startsWith(pkg)) continue;
                    interestingLine = false;
                    break;
                }
                if (!interestingLine) continue;
                ++nb;
            }
            return nb >= ThreadsAction.this.threshold;
        }

        private void printThreadInfo(String indent) {
            this.printThread(indent);
            StackTraceElement[] stacktrace = this.info.getStackTrace();
            MonitorInfo[] monitors = this.info.getLockedMonitors();
            for (int i = 0; i < stacktrace.length; ++i) {
                StackTraceElement ste = stacktrace[i];
                System.out.println(indent + "at " + ste.toString());
                for (MonitorInfo mi : monitors) {
                    if (mi.getLockedStackDepth() != i) continue;
                    System.out.println(indent + "  - locked " + mi);
                }
            }
            System.out.println();
        }

        private void printThread(String indent) {
            StringBuilder sb = new StringBuilder("\"" + this.info.getThreadName() + "\"" + " Id=" + this.info.getThreadId() + " in " + (Object)((Object)this.info.getThreadState()));
            if (this.info.getLockName() != null) {
                sb.append(" on lock=" + this.info.getLockName());
            }
            if (this.info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (this.info.isInNative()) {
                sb.append(" (running in native)");
            }
            System.out.println(sb.toString());
            if (this.info.getLockOwnerName() != null) {
                System.out.println(indent + " owned by " + this.info.getLockOwnerName() + " Id=" + this.info.getLockOwnerId());
            }
        }

        private void printMonitorInfo(String indent) {
            MonitorInfo[] monitors = this.info.getLockedMonitors();
            if (monitors != null && monitors.length > 0) {
                System.out.println(indent + "Locked monitors: count = " + monitors.length);
                for (MonitorInfo mi : monitors) {
                    System.out.println(indent + "  - " + mi + " locked at ");
                    System.out.println(indent + "      " + mi.getLockedStackDepth() + " " + mi.getLockedStackFrame());
                }
                System.out.println();
            }
        }

        private void printLockInfo(String indent) {
            LockInfo[] locks = this.info.getLockedSynchronizers();
            if (locks != null && locks.length > 0) {
                System.out.println(indent + "Locked synchronizers: count = " + locks.length);
                for (LockInfo li : locks) {
                    System.out.println(indent + "  - " + li);
                }
                System.out.println();
            }
        }
    }

    public class ThreadGroupData {
        private final ThreadGroup group;
        private final List<ThreadGroupData> groups;
        private final List<ThreadData> threads;

        public ThreadGroupData(ThreadGroup group, Map<Long, ThreadInfo> infos) {
            int nbThreads;
            int nbGroups;
            this.group = group;
            ThreadGroup[] childGroups = new ThreadGroup[32];
            while ((nbGroups = group.enumerate(childGroups, false)) == childGroups.length) {
                childGroups = new ThreadGroup[childGroups.length * 2];
            }
            this.groups = new ArrayList<ThreadGroupData>();
            for (ThreadGroup tg : childGroups) {
                if (tg == null) continue;
                this.groups.add(new ThreadGroupData(tg, infos));
            }
            Thread[] childThreads = new Thread[32];
            while ((nbThreads = group.enumerate(childThreads, false)) == childThreads.length) {
                childThreads = new Thread[childThreads.length * 2];
            }
            this.threads = new ArrayList<ThreadData>();
            for (Thread t : childThreads) {
                if (t == null) continue;
                this.threads.add(new ThreadData(t, infos.get(t.getId())));
            }
        }

        public void print() {
            if (ThreadsAction.this.tree) {
                this.printTree("");
            } else {
                this.printDump("");
            }
        }

        private void printTree(String indent) {
            if (ThreadsAction.this.empty || this.hasInterestingThreads()) {
                System.out.println(indent + "Thread Group \"" + this.group.getName() + "\"");
                for (ThreadGroupData tgd : this.groups) {
                    tgd.printTree(indent + "    ");
                }
                for (ThreadData td : this.threads) {
                    if (!td.isInteresting()) continue;
                    td.printTree(indent + "    ");
                }
            }
        }

        private void printDump(String indent) {
            if (ThreadsAction.this.empty || this.hasInterestingThreads()) {
                for (ThreadGroupData tgd : this.groups) {
                    tgd.printDump(indent);
                }
                for (ThreadData td : this.threads) {
                    if (!td.isInteresting()) continue;
                    td.printDump(indent);
                }
            }
        }

        public boolean hasInterestingThreads() {
            for (ThreadData td : this.threads) {
                if (!td.isInteresting()) continue;
                return true;
            }
            for (ThreadGroupData tgd : this.groups) {
                if (!tgd.hasInterestingThreads()) continue;
                return true;
            }
            return false;
        }
    }
}

