/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheOperation {
    private String name = "";
    private Set<String> cacheNames = Collections.emptySet();
    private String key = "";
    private String condition = "";

    public void setName(String name) {
        Assert.hasText((String)name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCacheName(String cacheName) {
        Assert.hasText((String)cacheName);
        this.cacheNames = Collections.singleton(cacheName);
    }

    public void setCacheNames(String ... cacheNames) {
        this.cacheNames = new LinkedHashSet<String>(cacheNames.length);
        for (String cacheName : cacheNames) {
            Assert.hasText((String)cacheName, (String)"Cache name must be non-null if specified");
            this.cacheNames.add(cacheName);
        }
    }

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public void setKey(String key) {
        Assert.notNull((Object)key);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setCondition(String condition) {
        Assert.notNull((Object)condition);
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean equals(Object other) {
        return other instanceof CacheOperation && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getOperationDescription().toString();
    }

    protected StringBuilder getOperationDescription() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName());
        result.append("[").append(this.name);
        result.append("] caches=").append(this.cacheNames);
        result.append(" | key='").append(this.key);
        result.append("' | condition='").append(this.condition).append("'");
        return result;
    }
}

