/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureECDSA;
import org.apache.sshd.common.signature.SignatureRSA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentImpl
implements SshAgent {
    private final List<SshAgent.Pair<KeyPair, String>> keys = new ArrayList<SshAgent.Pair<KeyPair, String>>();
    private boolean closed;

    @Override
    public List<SshAgent.Pair<PublicKey, String>> getIdentities() throws IOException {
        if (this.closed) {
            throw new SshException("Agent closed");
        }
        ArrayList<SshAgent.Pair<PublicKey, String>> pks = new ArrayList<SshAgent.Pair<PublicKey, String>>();
        for (SshAgent.Pair<KeyPair, String> kp : this.keys) {
            pks.add(new SshAgent.Pair<PublicKey, String>(kp.getFirst().getPublic(), kp.getSecond()));
        }
        return pks;
    }

    @Override
    public byte[] sign(PublicKey key, byte[] data) throws IOException {
        if (this.closed) {
            throw new SshException("Agent closed");
        }
        SshAgent.Pair<KeyPair, String> kp = AgentImpl.getKeyPair(this.keys, key);
        if (kp == null) {
            throw new SshException("Key not found");
        }
        try {
            Signature verif;
            if (kp.getFirst().getPublic() instanceof DSAPublicKey) {
                verif = new SignatureDSA();
            } else if (kp.getFirst().getPublic() instanceof ECPublicKey) {
                ECPublicKey pubKey = (ECPublicKey)kp.getFirst().getPublic();
                verif = SignatureECDSA.getByCurveSize(pubKey.getParams());
            } else if (kp.getFirst().getPublic() instanceof RSAPublicKey) {
                verif = new SignatureRSA();
            } else {
                throw new SshException("Unsupported key type");
            }
            verif.init(kp.getFirst().getPublic(), kp.getFirst().getPrivate());
            verif.update(data, 0, data.length);
            return verif.sign();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public void addIdentity(KeyPair key, String comment) throws IOException {
        if (this.closed) {
            throw new SshException("Agent closed");
        }
        this.keys.add(new SshAgent.Pair<KeyPair, String>(key, comment));
    }

    @Override
    public void removeIdentity(PublicKey key) throws IOException {
        if (this.closed) {
            throw new SshException("Agent closed");
        }
        SshAgent.Pair<KeyPair, String> kp = AgentImpl.getKeyPair(this.keys, key);
        if (kp == null) {
            throw new SshException("Key not found");
        }
        this.keys.remove(kp);
    }

    @Override
    public void removeAllIdentities() throws IOException {
        if (this.closed) {
            throw new SshException("Agent closed");
        }
        this.keys.clear();
    }

    @Override
    public void close() {
        this.closed = true;
        this.keys.clear();
    }

    protected static SshAgent.Pair<KeyPair, String> getKeyPair(List<SshAgent.Pair<KeyPair, String>> keys, PublicKey key) {
        SshAgent.Pair<KeyPair, String> kp = null;
        for (SshAgent.Pair<KeyPair, String> k : keys) {
            if (!AgentImpl.areKeyEquals(key, k.getFirst().getPublic())) continue;
            kp = k;
            break;
        }
        return kp;
    }

    protected static boolean areKeyEquals(PublicKey k1, PublicKey k2) {
        if (k1 instanceof DSAPublicKey && k2 instanceof DSAPublicKey) {
            DSAPublicKey d1 = (DSAPublicKey)k1;
            DSAPublicKey d2 = (DSAPublicKey)k2;
            DSAParams p1 = d1.getParams();
            DSAParams p2 = d2.getParams();
            return d1.getY().equals(d2.getY()) && p1.getG().equals(p2.getG()) && p1.getP().equals(p2.getP()) && p1.getQ().equals(p2.getQ());
        }
        if (k1 instanceof ECPublicKey && k2 instanceof ECPublicKey) {
            ECPublicKey e1 = (ECPublicKey)k1;
            ECPublicKey e2 = (ECPublicKey)k2;
            ECParameterSpec p1 = e1.getParams();
            ECParameterSpec p2 = e2.getParams();
            return p1.getCofactor() == p2.getCofactor() && p1.getOrder().equals(p2.getOrder()) && e1.getW().equals(e2.getW()) && p1.getGenerator().equals(p2.getGenerator()) && p1.getCurve().equals(p2.getCurve());
        }
        if (k1 instanceof RSAPublicKey && k2 instanceof RSAPublicKey) {
            RSAPublicKey r1 = (RSAPublicKey)k1;
            RSAPublicKey r2 = (RSAPublicKey)k2;
            return r1.getModulus().equals(r2.getModulus()) && r1.getPublicExponent().equals(r2.getPublicExponent());
        }
        return false;
    }
}

