/*
 * Decompiled with CFR 0.152.
 */
package org.jledit;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Stack;
import jline.Terminal;
import jline.WindowsTerminal;
import jline.console.KeyMap;
import jline.console.Operation;
import org.fusesource.jansi.Ansi;
import org.jledit.ConsoleEditor;
import org.jledit.ContentManager;
import org.jledit.Coordinates;
import org.jledit.Editor;
import org.jledit.EditorOperation;
import org.jledit.EditorOperationType;
import org.jledit.StringEditor;
import org.jledit.collection.RollingStack;
import org.jledit.command.Command;
import org.jledit.command.CommandFactory;
import org.jledit.command.undo.UndoContext;
import org.jledit.command.undo.UndoContextAware;
import org.jledit.command.undo.UndoableCommand;
import org.jledit.jline.InputStreamReader;
import org.jledit.jline.NonBlockingInputStream;
import org.jledit.terminal.JlEditTerminalFactory;
import org.jledit.theme.DefaultTheme;
import org.jledit.theme.Theme;
import org.jledit.utils.Closeables;
import org.jledit.utils.JlEditConsole;

public abstract class AbstractConsoleEditor
implements ConsoleEditor,
CommandFactory {
    public static final String EDITOR_NAME = "JLEdit";
    public static final String DIRTY_SIGN = "*";
    public static final int ESCAPE = 27;
    public static final int DEFAULT_ESCAPE_TIMEOUT = 100;
    public static final int READ_EXPIRED = -2;
    private final UndoContext undoContext = new UndoContext();
    private final RollingStack<Coordinates> cursorPositions = new RollingStack();
    private int frameLine = 1;
    private int frameColumn = 1;
    private final Terminal terminal;
    private KeyMap keys;
    private boolean running = false;
    private NonBlockingInputStream in;
    private long escapeTimeout;
    private Reader reader;
    private String file;
    private String displayAs = "<no file>";
    private String title = "JLEdit";
    private int headerSize = 1;
    private int footerSize = 1;
    private boolean readOnly = false;
    private boolean isOpenEnabled = true;
    private String highLight;
    private Editor<String> delegate = new StringEditor();
    private Theme theme = new DefaultTheme();
    private final JlEditConsole console;

    public AbstractConsoleEditor(Terminal term, InputStream in, PrintStream out) throws Exception {
        this.terminal = JlEditTerminalFactory.get(term);
        this.console = new JlEditConsole(in, out, out);
    }

    public final void init() throws Exception {
        boolean nonBlockingEnabled;
        this.escapeTimeout = 100L;
        boolean bl = nonBlockingEnabled = this.escapeTimeout > 0L && this.terminal.isSupported() && this.in != null;
        if (this.in != null) {
            this.in.shutdown();
        }
        InputStream wrapped = this.terminal.wrapInIfNeeded(System.in);
        this.in = new NonBlockingInputStream(wrapped, nonBlockingEnabled);
        this.reader = new InputStreamReader(this.in);
    }

    @Override
    public void start() {
        this.running = true;
        try {
            this.init();
            this.show();
            while (this.running) {
                EditorOperation operation = this.readOperation();
                if (operation == null) continue;
                Command cmd = this.create(operation);
                this.onCommand(cmd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        this.hide();
        this.running = false;
        Closeables.closeQuitely(this.reader);
        Closeables.closeQuitely(this.in);
    }

    @Override
    public void show() {
        this.repaintScreen();
        this.frameLine = 1;
        this.frameColumn = 1;
        this.delegate.move(1, 1);
        this.flush();
    }

    @Override
    public void hide() {
        this.console.out().print("\u001b[1;" + this.terminal.getHeight() + ";r");
        for (int l = 1; l <= this.terminal.getHeight(); ++l) {
            this.console.out().print(Ansi.ansi().cursor(l, 1));
            this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
        }
        this.console.out().print(Ansi.ansi().cursor(1, 1));
        this.flush();
        try {
            this.terminal.restore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readBoolean("", false);
    }

    @Override
    public boolean readBoolean(String message, Boolean defaultValue) throws IOException {
        this.saveCursorPosition();
        Ansi style = Ansi.ansi();
        if (this.getTheme().getPromptBackground() != null) {
            style.bg(this.getTheme().getPromptBackground());
        }
        if (this.getTheme().getPromptForeground() != null) {
            style.fg(this.getTheme().getPromptForeground());
        }
        for (int i = 1; i <= this.getFooterSize(); ++i) {
            this.console.out().print(Ansi.ansi().cursor(this.terminal.getHeight() - this.getFooterSize() + i, 1));
            this.console.out().print(style.eraseLine(Ansi.Erase.FORWARD));
        }
        this.console.out().print(Ansi.ansi().cursor(this.terminal.getHeight(), 1));
        this.console.out().print(style.a(message).bold().eraseLine(Ansi.Erase.FORWARD));
        this.restoreCursorPosition();
        this.flush();
        try {
            block11: while (true) {
                EditorOperation operation = this.readOperation();
                switch (operation.getType()) {
                    case NEWLINE: {
                        boolean bl = defaultValue;
                        return bl;
                    }
                    case TYPE: {
                        if ("y".equals(operation.getInput()) || "Y".equals(operation.getInput())) {
                            boolean bl = true;
                            return bl;
                        }
                        if (!"n".equals(operation.getInput()) && !"N".equals(operation.getInput())) continue block11;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            this.redrawFooter();
        }
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder lineBuilder = new StringBuilder();
        while (true) {
            EditorOperation operation = this.readOperation();
            switch (operation.getType()) {
                case BACKSAPCE: 
                case DELETE: {
                    if (lineBuilder.length() <= 0) break;
                    lineBuilder.delete(lineBuilder.length() - 1, lineBuilder.length());
                    this.console.out().print(Ansi.ansi().cursorLeft(1));
                    this.console.out().print(" ");
                    this.console.out().print(Ansi.ansi().cursorLeft(1));
                    break;
                }
                case NEWLINE: {
                    return lineBuilder.toString();
                }
                case TYPE: {
                    this.console.out().print(operation.getInput());
                    lineBuilder.append(operation.getInput());
                }
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine(String message) throws IOException {
        String result = null;
        this.saveCursorPosition();
        Ansi style = Ansi.ansi();
        if (this.getTheme().getPromptBackground() != null) {
            style.bg(this.getTheme().getPromptBackground());
        }
        if (this.getTheme().getPromptForeground() != null) {
            style.fg(this.getTheme().getPromptForeground());
        }
        for (int i = 1; i <= this.getFooterSize(); ++i) {
            this.console.out().print(Ansi.ansi().cursor(this.terminal.getHeight() - this.getFooterSize() + i, 1));
            this.console.out().print(style.eraseLine(Ansi.Erase.FORWARD));
        }
        this.console.out().print(Ansi.ansi().cursor(this.terminal.getHeight(), 1));
        this.console.out().print(Ansi.ansi().cursor(this.terminal.getHeight(), 1));
        this.console.out().print(style.a(message).bold().eraseLine(Ansi.Erase.FORWARD));
        this.flush();
        try {
            result = this.readLine();
        }
        finally {
            this.console.out().print(Ansi.ansi().reset());
            this.restoreCursorPosition();
            this.redrawFooter();
        }
        return result;
    }

    protected EditorOperation readOperation() throws IOException {
        Object o;
        int c;
        Stack<Character> pushBackChar;
        StringBuilder sb;
        block5: {
            sb = new StringBuilder();
            pushBackChar = new Stack<Character>();
            do {
                int n = c = pushBackChar.isEmpty() ? this.reader.read() : (int)((Character)pushBackChar.pop()).charValue();
                if (c == -1) {
                    return null;
                }
                sb.append((char)c);
                o = this.keys.getBound((CharSequence)sb);
                if (o == Operation.DO_LOWERCASE_VERSION) {
                    sb.setLength(sb.length() - 1);
                    sb.append(Character.toLowerCase((char)c));
                    o = this.keys.getBound((CharSequence)sb);
                }
                if (!(o instanceof KeyMap)) break block5;
            } while (c != 27 || !pushBackChar.isEmpty() || !this.in.isNonBlockingEnabled() || this.in.peek(this.escapeTimeout) != -2 || (o = ((KeyMap)o).getAnotherKey()) == null || o instanceof KeyMap);
            sb.setLength(0);
        }
        while (o == null && sb.length() > 0) {
            c = sb.charAt(sb.length() - 1);
            sb.setLength(sb.length() - 1);
            Object o2 = this.keys.getBound((CharSequence)sb);
            if (!(o2 instanceof KeyMap) || (o = ((KeyMap)o2).getAnotherKey()) == null) continue;
            pushBackChar.push(Character.valueOf((char)c));
        }
        if (o instanceof EditorOperationType) {
            EditorOperationType op = (EditorOperationType)((Object)o);
            return new EditorOperation(op, sb.toString());
        }
        return null;
    }

    public void onCommand(Command command) {
        try {
            if (UndoContextAware.class.isAssignableFrom(command.getClass())) {
                ((UndoContextAware)((Object)command)).setUndoContext(this.undoContext);
            } else if (UndoableCommand.class.isAssignableFrom(command.getClass())) {
                this.undoContext.undoPush((UndoableCommand)command);
            }
            command.execute();
            if (this.running) {
                this.redrawCoords();
                this.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void repaintScreen() {
        int repaintLine = 1;
        this.console.out().print(Ansi.ansi().eraseScreen(Ansi.Erase.ALL));
        this.console.out().print(Ansi.ansi().cursor(1, 1));
        this.console.out().print("\u001b[" + (this.getHeaderSize() + 1) + ";" + (this.terminal.getHeight() - this.getFooterSize()) + ";r");
        this.redrawHeader();
        this.redrawFooter();
        LinkedList<String> linesToDisplay = new LinkedList<String>();
        int l = 1;
        while (linesToDisplay.size() < this.terminal.getHeight() - this.getFooterSize()) {
            String currentLine = this.getContent(l++);
            linesToDisplay.addAll(this.toDisplayLines(currentLine));
        }
        for (int i = 0; i < this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize(); ++i) {
            this.console.out().print(Ansi.ansi().cursor(repaintLine + this.getHeaderSize(), 1));
            this.displayText((String)linesToDisplay.get(i));
            ++repaintLine;
        }
        this.console.out().print(Ansi.ansi().cursor(2, 1));
    }

    void redrawRestOfLine() {
        int maxLinesToRepaint = this.terminal.getHeight() - this.getFooterSize() - this.frameLine;
        LinkedList<String> toRepaintLines = new LinkedList<String>();
        String currentLine = this.getContent(this.getLine());
        toRepaintLines.addAll(this.toDisplayLines(currentLine));
        int remainingLines = (this.getColumn() - 1) / this.terminal.getWidth();
        for (int r = 0; r < remainingLines; ++r) {
            toRepaintLines.removeFirst();
        }
        this.saveCursorPosition();
        for (int l = 0; l < Math.min(maxLinesToRepaint, toRepaintLines.size()); ++l) {
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize() + l, 1));
            this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
            this.displayText((String)toRepaintLines.get(l));
        }
        this.restoreCursorPosition();
    }

    void redrawRestOfScreen() {
        int linesToRepaint = this.terminal.getHeight() - this.getFooterSize() - this.frameLine;
        LinkedList<String> toRepaintLines = new LinkedList<String>();
        String currentLine = this.getContent(this.getLine());
        toRepaintLines.addAll(this.toDisplayLines(currentLine));
        int remainingLines = Math.max(0, this.getColumn() - 1) / this.terminal.getWidth();
        for (int r = 0; r < remainingLines; ++r) {
            toRepaintLines.removeFirst();
        }
        boolean eof = false;
        int l = 1;
        while (toRepaintLines.size() < linesToRepaint && !eof) {
            try {
                toRepaintLines.addAll(this.toDisplayLines(this.getContent(this.getLine() + l)));
            }
            catch (Exception e) {
                eof = true;
            }
            ++l;
        }
        this.saveCursorPosition();
        for (l = 0; l < linesToRepaint; ++l) {
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize() + l, 1));
            this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
            if (toRepaintLines.size() > l) {
                this.displayText((String)toRepaintLines.get(l));
                continue;
            }
            this.displayText("");
        }
        this.restoreCursorPosition();
    }

    @Override
    public void redrawText() {
        int startLine = this.getLine();
        int startColum = this.getColumn();
        while (this.frameLine > 1) {
            this.moveUp(1);
        }
        while (this.frameColumn > 1) {
            this.moveLeft(1);
        }
        this.redrawRestOfScreen();
        this.move(startLine, startColum);
    }

    @Override
    public int getLine() {
        return this.delegate.getLine();
    }

    @Override
    public int getColumn() {
        return this.delegate.getColumn();
    }

    @Override
    public void move(int line, int column) {
        if (line <= 0) {
            throw new IndexOutOfBoundsException("Minimum valid line is 1.");
        }
        int verticalOffset = line - this.getLine();
        this.moveVertical(verticalOffset);
        int horizontalOffset = column - this.getColumn();
        this.moveHorizontally(horizontalOffset);
    }

    private void moveVertical(int offset) {
        if (offset < 0) {
            this.moveUp(Math.abs(offset));
        } else if (offset > 0) {
            this.moveDown(offset);
        }
    }

    @Override
    public void moveUp(int offset) {
        LinkedList<String> toDisplayLines = new LinkedList<String>();
        for (int i = 0; i < offset; ++i) {
            toDisplayLines.clear();
            String currentLine = this.getContent(this.getLine());
            toDisplayLines.addAll(this.toDisplayLines(currentLine));
            int remainingLines = toDisplayLines.size() - this.getColumn() / this.terminal.getWidth();
            for (int r = 0; r < remainingLines; ++r) {
                toDisplayLines.removeLast();
            }
            this.delegate.move(this.getLine() - 1, this.getColumn());
            currentLine = this.getContent(this.getLine());
            toDisplayLines.addAll(this.toDisplayLines(currentLine));
            for (int l = toDisplayLines.size() - 1; l >= 0; --l) {
                int actualColumn;
                --this.frameLine;
                if (this.frameLine <= 0) {
                    this.frameLine = 1;
                    this.scrollDown(1);
                    this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), 1));
                    this.displayText((String)toDisplayLines.get(l));
                    this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.getColumn()));
                }
                for (actualColumn = this.getColumn(); actualColumn > this.terminal.getWidth(); actualColumn -= this.terminal.getWidth()) {
                }
                this.frameColumn = actualColumn;
                this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
            }
        }
    }

    @Override
    public void moveDown(int offset) {
        LinkedList<String> toDisplayLines = new LinkedList<String>();
        for (int i = 0; i < offset; ++i) {
            toDisplayLines.clear();
            String currentLine = this.getContent(this.getLine());
            toDisplayLines.addAll(this.toDisplayLines(currentLine));
            int remainingLines = this.getColumn() / this.terminal.getWidth() + 1;
            for (int r = 0; r < remainingLines; ++r) {
                toDisplayLines.removeFirst();
            }
            this.delegate.move(this.getLine() + 1, this.getColumn());
            currentLine = this.getContent(this.getLine());
            toDisplayLines.add(this.toDisplayLines(currentLine).getFirst());
            for (int l = 0; l < toDisplayLines.size(); ++l) {
                int actualColumn;
                ++this.frameLine;
                if (this.frameLine >= this.terminal.getHeight() - this.getFooterSize()) {
                    this.frameLine = this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize();
                    this.scrollUp(1);
                    this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), 1));
                    this.displayText((String)toDisplayLines.get(l));
                    this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.getColumn()));
                }
                for (actualColumn = this.getColumn(); actualColumn > this.terminal.getWidth(); actualColumn -= this.terminal.getWidth()) {
                }
                this.frameColumn = actualColumn;
                this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
            }
        }
    }

    private void moveHorizontally(int offset) {
        if (offset < 0) {
            this.moveLeft(Math.abs(offset));
        } else if (offset > 0) {
            this.moveRight(offset);
        }
    }

    @Override
    public void moveLeft(int offset) {
        for (int i = 0; i < offset; ++i) {
            --this.frameColumn;
            if (this.frameColumn <= 0) {
                String currentLine = this.getContent(this.getLine());
                int currentLineLength = currentLine.length();
                if (currentLineLength > this.terminal.getWidth() && this.getColumn() > 1) {
                    if (this.frameLine != 1) {
                        --this.frameLine;
                        this.frameColumn = this.terminal.getWidth();
                        this.delegate.move(this.getLine(), this.getColumn() - 1);
                        continue;
                    }
                    this.frameLine = 1;
                    this.frameColumn = 1;
                    this.delegate.move(this.getLine(), this.getColumn() - 1);
                    continue;
                }
                this.frameColumn = 1;
                String previousLine = this.getContent(this.getLine() - 1);
                this.moveUp(1);
                this.frameColumn = previousLine.length() + 1;
                while (this.frameColumn > this.terminal.getWidth()) {
                    this.frameColumn -= this.terminal.getWidth();
                    ++this.frameLine;
                }
                this.delegate.move(this.getLine(), previousLine.length() + 1);
                continue;
            }
            this.delegate.move(this.getLine(), this.getColumn() - 1);
        }
        this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
    }

    @Override
    public void moveRight(int offset) {
        for (int i = 0; i < offset; ++i) {
            int actualContentLength = this.getContent(this.getLine()).length();
            ++this.frameColumn;
            if (this.frameColumn > actualContentLength + 1 || this.getColumn() > actualContentLength) {
                this.frameColumn = 1;
                this.moveDown(1);
                this.moveToStartOfLine();
                continue;
            }
            if (this.frameColumn > this.terminal.getWidth()) {
                String currentLine = this.getContent(this.getLine());
                this.frameColumn = 1;
                LinkedList<String> toDisplayLines = this.toDisplayLines(currentLine);
                int remainingLines = toDisplayLines.size() - this.getColumn() / this.terminal.getWidth();
                for (int r = 0; r < remainingLines; ++r) {
                    toDisplayLines.removeFirst();
                }
                ++this.frameLine;
                if (this.frameLine >= this.terminal.getHeight() - this.getFooterSize()) {
                    this.frameLine = this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize();
                    this.scrollUp(1);
                    this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), 1));
                    this.displayText(toDisplayLines.get(0));
                    this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.getColumn()));
                }
                this.delegate.move(this.getLine(), this.getColumn() + 1);
                continue;
            }
            this.delegate.move(this.getLine(), this.getColumn() + 1);
        }
        this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
    }

    @Override
    public void moveToEndOfLine() {
        String currentLine = this.getContent(this.getLine());
        LinkedList<String> toDisplayLines = this.toDisplayLines(currentLine);
        int remainingLines = this.getColumn() / this.terminal.getWidth() + 1;
        for (int r = 0; r < remainingLines; ++r) {
            toDisplayLines.removeFirst();
        }
        this.frameColumn = currentLine.length();
        this.delegate.moveToEndOfLine();
        for (int l = 0; l < toDisplayLines.size(); ++l) {
            ++this.frameLine;
            this.frameColumn -= this.terminal.getWidth();
            if (this.frameLine < this.terminal.getHeight() - this.getFooterSize()) continue;
            this.frameLine = this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize();
            this.scrollUp(1);
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), 1));
            this.displayText(toDisplayLines.get(l));
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.getColumn()));
        }
        this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
    }

    @Override
    public void moveToStartOfLine() {
        String currentLine = this.getContent(this.getLine());
        LinkedList<String> toDisplayLines = this.toDisplayLines(currentLine);
        int remainingLines = toDisplayLines.size() - this.getColumn() / this.terminal.getWidth();
        for (int r = 0; r < remainingLines; ++r) {
            toDisplayLines.removeLast();
        }
        this.frameColumn = 1;
        this.delegate.moveToStartOfLine();
        for (int l = toDisplayLines.size() - 1; l >= 0; --l) {
            --this.frameLine;
            if (this.frameLine > 0) continue;
            this.frameLine = 1;
            this.scrollDown(1);
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), 1));
            this.displayText(toDisplayLines.get(l));
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.getColumn()));
        }
        this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
    }

    @Override
    public void moveToStartOfFile() {
        this.delegate.moveToStartOfFile();
        this.redrawRestOfScreen();
    }

    @Override
    public void moveToEndOfFile() {
        this.delegate.moveToEndOfFile();
        this.redrawText();
    }

    @Override
    public void put(String str) {
        if (str.contains("\n")) {
            String[] lines = str.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (i != 0) {
                    this.newLine();
                }
                this.put(lines[i]);
            }
            if (str.endsWith("\n")) {
                this.newLine();
            }
        } else {
            int startingFromColumn = this.getColumn();
            this.delegate.put(str);
            String modifiedLine = this.getContent(this.getLine());
            LinkedList<String> toDisplayLines = this.toDisplayLines(modifiedLine);
            this.frameColumn += str.length();
            if (this.frameColumn > this.terminal.getWidth()) {
                int current = (startingFromColumn - 1) / this.terminal.getWidth();
                this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), 1));
                this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
                this.displayText(toDisplayLines.get(current));
                this.frameLine += this.frameColumn / this.terminal.getWidth();
                this.frameColumn -= str.length();
                while (this.frameLine > this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize()) {
                    this.frameLine = this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize();
                    this.scrollUp(1);
                }
            }
            if (toDisplayLines.size() > 1) {
                this.redrawRestOfScreen();
            } else {
                this.redrawRestOfLine();
            }
            this.frameColumn = this.getColumn();
            while (this.frameColumn > this.terminal.getWidth()) {
                this.frameColumn -= this.terminal.getWidth();
            }
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
        }
    }

    @Override
    public String delete() {
        this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
        String r = this.delegate.delete();
        if (r.equals("\n") || r.equals("\r")) {
            this.redrawRestOfScreen();
        } else {
            this.redrawRestOfLine();
        }
        return r;
    }

    @Override
    public String backspace() {
        String b = null;
        if (this.getColumn() == 1) {
            this.moveUp(1);
            this.moveToEndOfLine();
            this.delegate.move(this.getLine(), this.getColumn() + 1);
            this.mergeLine();
            this.redrawRestOfScreen();
            return "\n";
        }
        if (this.frameColumn == 1) {
            --this.frameLine;
            this.frameColumn = this.terminal.getWidth();
            b = this.delegate.backspace();
            String currentLine = this.getContent(this.getLine());
            LinkedList<String> toDisplayLines = this.toDisplayLines(currentLine);
            int multiLineNumber = this.getColumn() / this.terminal.getWidth();
            if (this.frameLine == 0) {
                this.frameLine = 1;
                this.scrollDown(1);
            }
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), 1));
            this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
            this.displayText(toDisplayLines.get(multiLineNumber - 1));
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + 2, 1));
            this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
            this.displayText(toDisplayLines.get(multiLineNumber));
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
            this.redrawRestOfScreen();
        } else {
            b = this.delegate.backspace();
            String currentLine = this.getContent(this.getLine());
            --this.frameColumn;
            if (currentLine.length() < this.terminal.getWidth()) {
                this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.getColumn()));
                this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
                String modifiedLine = this.getContent(this.getLine());
                this.displayText(modifiedLine.substring(this.getColumn() - 1));
            } else {
                this.redrawRestOfScreen();
            }
            this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
        }
        return b;
    }

    @Override
    public void newLine() {
        this.delegate.newLine();
        this.console.out().print(Ansi.ansi().eraseLine(Ansi.Erase.FORWARD));
        this.frameColumn = 1;
        ++this.frameLine;
        if (this.frameLine > this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize()) {
            this.frameLine = this.terminal.getHeight() - this.getHeaderSize() - this.getFooterSize();
            this.scrollUp(1);
        }
        this.redrawRestOfScreen();
        this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
    }

    @Override
    public void mergeLine() {
        String currentLine = this.getContent(this.getLine());
        this.frameColumn = currentLine.length() % this.terminal.getWidth() + 1;
        if (this.frameColumn == this.terminal.getWidth()) {
            this.frameColumn = 1;
            ++this.frameLine;
        }
        this.delegate.mergeLine();
        this.redrawRestOfScreen();
        this.console.out().print(Ansi.ansi().cursor(this.frameLine + this.getHeaderSize(), this.frameColumn));
    }

    @Override
    public void findNext(String str) {
        int startLine = this.getLine();
        int startColumn = this.getColumn();
        this.highLight(str);
        this.delegate.findNext(str);
        int targetLine = this.getLine();
        int targetColumn = this.getColumn();
        this.delegate.move(startLine, startColumn);
        int verticalOffset = targetLine - this.getLine();
        this.moveVertical(verticalOffset);
        int horizontalOffset = targetColumn - this.getColumn();
        this.moveHorizontally(horizontalOffset);
        this.redrawText();
    }

    @Override
    public void findPrevious(String str) {
        int startLine = this.getLine();
        int startColumn = this.getColumn();
        this.highLight(str);
        this.delegate.findPrevious(str);
        int targetLine = this.getLine();
        int targetColumn = this.getColumn();
        this.delegate.move(startLine, startColumn);
        int verticalOffset = targetLine - this.getLine();
        this.moveVertical(verticalOffset);
        int horizontalOffset = targetColumn - this.getColumn();
        this.moveHorizontally(horizontalOffset);
        this.redrawText();
    }

    protected void scrollUp(int rows) {
        if (WindowsTerminal.class.isAssignableFrom(this.terminal.getClass())) {
            this.redrawText();
        } else {
            this.console.out().print(Ansi.ansi().scrollUp(rows));
        }
    }

    protected void scrollDown(int rows) {
        if (WindowsTerminal.class.isAssignableFrom(this.terminal.getClass())) {
            this.redrawText();
        } else {
            this.console.out().print(Ansi.ansi().scrollDown(rows));
        }
    }

    protected void displayText(String text) {
        if (this.highLight != null && !this.highLight.isEmpty() && text.contains(this.highLight)) {
            String highLightedText = text.replaceAll(this.highLight, Ansi.ansi().bold().bg(this.theme.getHighLightBackground()).fg(this.theme.getHighLightForeground()).a(this.highLight).boldOff().reset().toString());
            this.console.out().print(highLightedText);
        } else {
            this.console.out().print(text);
        }
    }

    protected void clearLine() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.terminal.getWidth(); ++i) {
            sb.append(" ");
        }
        this.console.out().print(sb.toString());
    }

    @Override
    public void saveCursorPosition() {
        this.cursorPositions.push(new Coordinates(this.frameLine, this.frameColumn));
    }

    @Override
    public void restoreCursorPosition() {
        Coordinates coordinates = this.cursorPositions.pop();
        if (coordinates != null) {
            this.console.out().print(Ansi.ansi().cursor(coordinates.getLine() + this.getHeaderSize(), coordinates.getColumn()));
        }
    }

    public void flush() {
        this.console.out().flush();
    }

    protected void highLight(String text) {
        this.highLight = text;
    }

    @Override
    public void open(String source, String displayAs) throws IOException {
        this.displayAs = displayAs;
        this.file = source;
        this.delegate.open(source);
        this.frameLine = 1;
        this.frameColumn = 1;
    }

    @Override
    public void open(String source) throws IOException {
        this.open(source, source);
    }

    @Override
    public void save(String target) throws IOException {
        if (target != null) {
            this.file = target;
            this.delegate.save(target);
            this.displayAs = target;
        } else {
            this.delegate.save(this.file);
        }
        this.setDirty(false);
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
            this.file = null;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int lines() {
        return this.delegate.lines();
    }

    @Override
    public String getContent() {
        return this.delegate.getContent();
    }

    @Override
    public String getContent(int line) {
        return this.delegate.getContent(line);
    }

    @Override
    public String getSource() {
        return this.file;
    }

    private LinkedList<String> toDisplayLines(String line) {
        LinkedList<String> displayLines = new LinkedList<String>();
        if (line.length() <= this.terminal.getWidth()) {
            displayLines.add(line);
        } else {
            int total = Math.max(0, line.length() - 1) / this.terminal.getWidth() + 1;
            int startIndex = 0;
            for (int l = 0; l < total; ++l) {
                displayLines.add(line.substring(startIndex, Math.min(startIndex + this.terminal.getWidth(), line.length())));
                startIndex += this.terminal.getWidth();
            }
        }
        return displayLines;
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    public Editor<String> getDelegate() {
        return this.delegate;
    }

    @Override
    public Boolean isDirty() {
        return this.delegate.isDirty();
    }

    @Override
    public void setDirty(Boolean dirty) {
        this.delegate.setDirty(dirty);
    }

    @Override
    public ContentManager getContentManager() {
        return this.delegate.getContentManager();
    }

    @Override
    public void setContentManager(ContentManager contentManager) {
        this.delegate.setContentManager(contentManager);
    }

    @Override
    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public int getFooterSize() {
        return this.footerSize;
    }

    public void setFooterSize(int footerSize) {
        this.footerSize = footerSize;
    }

    public KeyMap getKeys() {
        return this.keys;
    }

    public void setKeys(KeyMap keys) {
        this.keys = keys;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public UndoContext getUndoContext() {
        return this.undoContext;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isOpenEnabled() {
        return this.isOpenEnabled;
    }

    @Override
    public void setOpenEnabled(boolean openEnabled) {
        this.isOpenEnabled = openEnabled;
    }

    public String getDisplayAs() {
        return this.displayAs;
    }

    public void setDisplayAs(String displayAs) {
        this.displayAs = displayAs;
    }

    public JlEditConsole getConsole() {
        return this.console;
    }
}

