/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.kar.internal.osgi;

import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.kar.KarService;
import org.apache.karaf.kar.internal.KarServiceImpl;
import org.apache.karaf.kar.internal.KarsMBeanImpl;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.service.cm.ManagedService;

@Services(requires={@RequireService(value=FeaturesService.class)}, provides={@ProvideService(value=KarService.class)})
@Managed(value="org.apache.karaf.kar")
public class Activator
extends BaseActivator
implements ManagedService {
    @Override
    protected void doStart() throws Exception {
        FeaturesService featuresService = this.getTrackedService(FeaturesService.class);
        if (featuresService == null) {
            return;
        }
        boolean noAutoRefreshBundles = this.getBoolean("noAutoRefreshBundles", false);
        KarServiceImpl karService = new KarServiceImpl(System.getProperty("karaf.base"), System.getProperty("karaf.data"), featuresService);
        karService.setNoAutoRefreshBundles(noAutoRefreshBundles);
        this.register(KarService.class, karService);
        KarsMBeanImpl mbean = new KarsMBeanImpl();
        mbean.setKarService(karService);
        this.registerMBean(mbean, "type=kar");
    }
}

