/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import shaded.org.eclipse.aether.transfer.NoRepositoryLayoutException;
import shaded.org.eclipse.aether.util.ConfigUtils;

@Named(value="maven2")
public final class Maven2RepositoryLayoutFactory
implements RepositoryLayoutFactory {
    static final String CONFIG_PROP_SIGNATURE_CHECKSUMS = "aether.checksums.forSignature";
    private float priority;

    public float getPriority() {
        return this.priority;
    }

    public Maven2RepositoryLayoutFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    public RepositoryLayout newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryLayoutException(repository);
        }
        boolean forSignature = ConfigUtils.getBoolean(session, false, CONFIG_PROP_SIGNATURE_CHECKSUMS);
        return forSignature ? Maven2RepositoryLayout.INSTANCE : Maven2RepositoryLayoutEx.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Maven2RepositoryLayoutEx
    extends Maven2RepositoryLayout {
        public static final RepositoryLayout INSTANCE = new Maven2RepositoryLayoutEx();

        private Maven2RepositoryLayoutEx() {
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location) {
            if (this.isSignature(artifact.getExtension())) {
                return Collections.emptyList();
            }
            return super.getChecksums(artifact, upload, location);
        }

        private boolean isSignature(String extension) {
            return extension.endsWith(".asc");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Maven2RepositoryLayout
    implements RepositoryLayout {
        public static final RepositoryLayout INSTANCE = new Maven2RepositoryLayout();

        private Maven2RepositoryLayout() {
        }

        private URI toUri(String path) {
            try {
                return new URI(null, null, path, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public URI getLocation(Artifact artifact, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            path.append(artifact.getGroupId().replace('.', '/')).append('/');
            path.append(artifact.getArtifactId()).append('/');
            path.append(artifact.getBaseVersion()).append('/');
            path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
            if (artifact.getClassifier().length() > 0) {
                path.append('-').append(artifact.getClassifier());
            }
            if (artifact.getExtension().length() > 0) {
                path.append('.').append(artifact.getExtension());
            }
            return this.toUri(path.toString());
        }

        @Override
        public URI getLocation(Metadata metadata, boolean upload) {
            StringBuilder path = new StringBuilder(128);
            if (metadata.getGroupId().length() > 0) {
                path.append(metadata.getGroupId().replace('.', '/')).append('/');
                if (metadata.getArtifactId().length() > 0) {
                    path.append(metadata.getArtifactId()).append('/');
                    if (metadata.getVersion().length() > 0) {
                        path.append(metadata.getVersion()).append('/');
                    }
                }
            }
            path.append(metadata.getType());
            return this.toUri(path.toString());
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Artifact artifact, boolean upload, URI location) {
            return this.getChecksums(location);
        }

        @Override
        public List<RepositoryLayout.Checksum> getChecksums(Metadata metadata, boolean upload, URI location) {
            return this.getChecksums(location);
        }

        private List<RepositoryLayout.Checksum> getChecksums(URI location) {
            return Arrays.asList(RepositoryLayout.Checksum.forLocation(location, "SHA-1"), RepositoryLayout.Checksum.forLocation(location, "MD5"));
        }
    }
}

