/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.editor;

import org.jledit.ConsoleEditor;
import org.jledit.command.editor.AbstractUndoableCommand;

public class ReplaceCharcterCommand
extends AbstractUndoableCommand {
    private Character deleted;
    private final String replace;

    public ReplaceCharcterCommand(ConsoleEditor editor, String replace) {
        super(editor);
        this.replace = replace;
    }

    @Override
    public void doExecute() {
        if (!this.getEditor().isReadOnly()) {
            this.deleted = Character.valueOf(this.getEditor().delete().charAt(0));
            this.getEditor().put(this.replace);
            this.getEditor().moveLeft(this.replace.length());
        }
    }

    @Override
    public void undo() {
        if (!this.getEditor().isReadOnly() && this.deleted != null && Character.isLetter(this.deleted.charValue())) {
            this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
            for (int c = 0; c < this.replace.length(); ++c) {
                this.getEditor().delete();
            }
            this.getEditor().put(this.deleted.toString());
            this.getEditor().moveLeft(1);
        }
    }
}

