/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reflective {
    public static final Object NO_MATCH = new Object();
    public static final String MAIN = "_main";
    public static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    /*
     * WARNING - void declaration
     */
    public static Object invoke(CommandSession session, Object target, String name, List<Object> args) throws Exception {
        void var14_20;
        Method[] methods = target.getClass().getMethods();
        name = name.toLowerCase();
        String get = "get" + name;
        String is = "is" + name;
        String set = "set" + name;
        if (KEYWORDS.contains(name)) {
            name = "_" + name;
        }
        if (target instanceof Class) {
            Method[] staticMethods;
            for (Method m : staticMethods = ((Class)target).getMethods()) {
                String mname = m.getName().toLowerCase();
                if (!mname.equals(name) && !mname.equals(get) && !mname.equals(set) && !mname.equals(is) && !mname.equals(MAIN)) continue;
                methods = staticMethods;
                break;
            }
        }
        Method bestMethod = null;
        Object[] bestArgs = null;
        int lowestMatch = Integer.MAX_VALUE;
        ArrayList<Class<?>[]> possibleTypes = new ArrayList<Class<?>[]>();
        Method[] arr$ = methods;
        int len$ = arr$.length;
        boolean bl = false;
        while (var14_20 < len$) {
            Method m = arr$[var14_20];
            String mname = m.getName().toLowerCase();
            if (mname.equals(name) || mname.equals(get) || mname.equals(set) || mname.equals(is) || mname.equals(MAIN)) {
                Object[] parms;
                int match;
                Class<?>[] types = m.getParameterTypes();
                ArrayList<Object> xargs = new ArrayList<Object>(args);
                if (mname.equals(MAIN)) {
                    xargs.add(0, name);
                }
                if ((match = Reflective.coerce(session, target, m, types, parms = new Object[types.length], xargs)) < 0) {
                    possibleTypes.add(types);
                } else {
                    if (match < lowestMatch) {
                        lowestMatch = match;
                        bestMethod = m;
                        bestArgs = parms;
                    }
                    if (match == 0) break;
                }
            }
            ++var14_20;
        }
        if (bestMethod != null) {
            bestMethod.setAccessible(true);
            try {
                return bestMethod.invoke(target, bestArgs);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Class[] classArray : possibleTypes) {
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            for (Class type : classArray) {
                if (buf.length() > 1) {
                    buf.append(", ");
                }
                buf.append(type.getSimpleName());
            }
            buf.append(')');
            list.add(buf.toString());
        }
        StringBuilder params = new StringBuilder();
        for (Object arg : args) {
            if (params.length() > 1) {
                params.append(", ");
            }
            params.append(arg == null ? "null" : arg.getClass().getSimpleName());
        }
        throw new IllegalArgumentException(String.format("Cannot coerce %s(%s) to any of %s", name, params, list));
    }

    private static List<Object> transformParameters(Method method, List<Object> in) {
        Annotation[][] pas = method.getParameterAnnotations();
        ArrayList<Object> out = new ArrayList<Object>();
        ArrayList<Object> parms = new ArrayList<Object>(in);
        Annotation[][] arr$ = pas;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] as;
            for (Annotation a : as = arr$[i$]) {
                String name;
                if (!(a instanceof Parameter)) continue;
                int i = -1;
                Parameter p = (Parameter)a;
                String[] arr$2 = p.names();
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2 && (i = parms.indexOf(name = arr$2[i$2])) < 0; ++i$2) {
                }
                if (i >= 0) {
                    parms.remove(i);
                    Object value = p.presentValue();
                    if ("org.apache.felix.service.command.unspecified.parameter".equals(value)) {
                        if (i >= parms.size()) {
                            return null;
                        }
                        value = parms.remove(i);
                    }
                    out.add(value);
                    continue;
                }
                out.add(p.absentValue());
            }
        }
        out.addAll(parms);
        return out;
    }

    private static int coerce(CommandSession session, Object target, Method m, Class<?>[] types, Object[] out, List<Object> in) {
        if ((in = Reflective.transformParameters(m, in)) == null) {
            return -1;
        }
        int[] convert = new int[]{0};
        if (types.length > 0 && types[0].isInterface() && types[0].isAssignableFrom(session.getClass())) {
            in.add(0, session);
        }
        for (int i = 0; i < out.length; ++i) {
            out[i] = null;
            if (in.size() == 0) {
                out[i] = NO_MATCH;
            } else {
                out[i] = Reflective.coerce(session, types[i], in.get(0), convert);
                if (out[i] == null && types[i].isArray() && in.size() > 0) {
                    out[i] = NO_MATCH;
                }
                if (out[i] != NO_MATCH) {
                    in.remove(0);
                }
            }
            if (out[i] != NO_MATCH) continue;
            if (types[i].isArray() && i == types.length - 1) {
                Class<?> ctype = types[i].getComponentType();
                int asize = in.size();
                Object array = Array.newInstance(ctype, asize);
                int n = i;
                while (in.size() > 0) {
                    Object t = Reflective.coerce(session, ctype, in.remove(0), convert);
                    if (t == NO_MATCH) {
                        return -1;
                    }
                    Array.set(array, i - n, t);
                    ++i;
                }
                out[n] = array;
                return convert[0] + 1 + asize * 2;
            }
            return -1;
        }
        if (in.isEmpty()) {
            return convert[0];
        }
        return -1;
    }

    private static Object coerce(CommandSession session, Class<?> type, Object arg, int[] convert) {
        if (arg == null) {
            return null;
        }
        if (type.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        if (type.isArray()) {
            return NO_MATCH;
        }
        if (type.isPrimitive() && arg instanceof Long) {
            Number num = (Number)arg;
            if (type == Short.TYPE) {
                return num.shortValue();
            }
            if (type == Integer.TYPE) {
                return num.intValue();
            }
            if (type == Long.TYPE) {
                return num.longValue();
            }
        }
        convert[0] = convert[0] + 2;
        Object converted = session.convert(type, arg);
        if (converted != null) {
            return converted;
        }
        String string = arg.toString();
        if (type.isAssignableFrom(String.class)) {
            return string;
        }
        if (type.isPrimitive()) {
            type = Reflective.primitiveToObject(type);
        }
        try {
            return type.getConstructor(String.class).newInstance(string);
        }
        catch (Exception e) {
            if (type == Character.class && string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            return NO_MATCH;
        }
    }

    private static Class<?> primitiveToObject(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        return null;
    }
}

