/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.common;

import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.KeyUtils;

public abstract class AbstractAgentClient {
    private final Buffer buffer = new Buffer();
    private final SshAgent agent;

    public AbstractAgentClient(SshAgent agent) {
        this.agent = agent;
    }

    public synchronized void messageReceived(Buffer message) throws IOException {
        this.buffer.putBuffer(message);
        if (this.buffer.available() < 4) {
            return;
        }
        int rpos = this.buffer.rpos();
        int len = this.buffer.getInt();
        this.buffer.rpos(rpos);
        if (this.buffer.available() < len + 4) {
            return;
        }
        Buffer rep = new Buffer();
        rep.putInt(0L);
        rep.rpos(rep.wpos());
        try {
            this.process(new Buffer(this.buffer.getBytes()), rep);
        }
        catch (Exception e) {
            rep.clear();
            rep.putInt(0L);
            rep.rpos(rep.wpos());
            rep.putInt(1L);
            rep.putByte((byte)30);
        }
        this.reply(this.prepare(rep));
    }

    protected void process(Buffer req, Buffer rep) throws Exception {
        byte cmd = req.getByte();
        switch (cmd) {
            case 11: {
                List<SshAgent.Pair<PublicKey, String>> keys = this.agent.getIdentities();
                rep.putByte((byte)12);
                rep.putInt(keys.size());
                for (SshAgent.Pair<PublicKey, String> key : keys) {
                    rep.putPublicKey(key.getFirst());
                    rep.putString(key.getSecond());
                }
                break;
            }
            case 13: {
                PublicKey key = req.getPublicKey();
                byte[] data = req.getBytes();
                int flags = req.getInt();
                Buffer sig = new Buffer();
                sig.putString(KeyUtils.getKeyType(key));
                sig.putBytes(this.agent.sign(key, data));
                rep.putByte((byte)14);
                rep.putBytes(sig.array(), sig.rpos(), sig.available());
                break;
            }
            case 17: {
                this.agent.addIdentity(req.getKeyPair(), req.getString());
                rep.putByte((byte)6);
                break;
            }
            case 18: {
                PublicKey key = req.getPublicKey();
                this.agent.removeIdentity(key);
                rep.putByte((byte)6);
                break;
            }
            case 19: {
                this.agent.removeAllIdentities();
                rep.putByte((byte)6);
                break;
            }
            default: {
                rep.putByte((byte)30);
            }
        }
    }

    protected Buffer prepare(Buffer buf) {
        int len = buf.available();
        int rpos = buf.rpos();
        int wpos = buf.wpos();
        buf.rpos(rpos - 4);
        buf.wpos(rpos - 4);
        buf.putInt(len);
        buf.wpos(wpos);
        return buf;
    }

    protected abstract void reply(Buffer var1) throws IOException;
}

