/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.parsing;

import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.parsing.DefaultParser;
import org.apache.karaf.shell.support.parsing.GogoParser;

public class CommandLineParser {
    public static CommandLine buildCommandLine(Session session, String command, int cursor) {
        CommandLine cmdLine;
        int length;
        int pos = 0;
        do {
            String rem = command.substring(pos);
            GogoParser cmdNameParser = new GogoParser(rem, rem.length());
            String name = cmdNameParser.value();
            name = session.resolveCommand(name);
            Parser cmdParser = null;
            for (Command cmd : session.getRegistry().getCommands()) {
                if (!name.equals(cmd.getScope() + ":" + cmd.getName())) continue;
                cmdParser = cmd.getParser();
                break;
            }
            if (cmdParser == null) {
                cmdParser = new DefaultParser();
            }
            if ((length = (cmdLine = cmdParser.parse(session, rem, cursor - pos)).getBuffer().length()) >= rem.length()) continue;
            char ch = rem.charAt(length);
            if (ch == ';' || ch == '|') {
                ++length;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized character: '" + ch + "'");
        } while (cursor > (pos += length));
        return cmdLine;
    }

    public static String parse(Session session, String command) {
        int length;
        StringBuilder parsed = new StringBuilder();
        for (int pos = 0; pos < command.length(); pos += length) {
            String rem = command.substring(pos);
            GogoParser cmdNameParser = new GogoParser(rem, rem.length());
            String name = cmdNameParser.value();
            name = session.resolveCommand(name);
            Parser cmdParser = null;
            for (Command cmd : session.getRegistry().getCommands()) {
                if (!name.equals(cmd.getScope() + ":" + cmd.getName())) continue;
                cmdParser = cmd.getParser();
                break;
            }
            if (cmdParser == null) {
                cmdParser = new DefaultParser();
            }
            CommandLine cmdLine = cmdParser.parse(session, rem, rem.length());
            parsed.append(cmdParser.preprocess(session, cmdLine));
            length = cmdLine.getBuffer().length();
            if (length >= rem.length()) continue;
            char ch = rem.charAt(length);
            if (ch == ';' || ch == '|') {
                parsed.append(" ");
                parsed.append(ch);
                parsed.append(" ");
                ++length;
                continue;
            }
            if (ch == '\n') {
                parsed.append(ch);
                ++length;
                continue;
            }
            throw new IllegalArgumentException("Unrecognized character: '" + ch + "'");
        }
        return parsed.toString();
    }
}

