/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.openmbean.CompositeData;
import org.apache.aries.jmx.blueprint.codec.BPBeanMetadata;
import org.apache.aries.jmx.blueprint.codec.BPCollectionMetadata;
import org.apache.aries.jmx.blueprint.codec.BPIdRefMetadata;
import org.apache.aries.jmx.blueprint.codec.BPMapMetadata;
import org.apache.aries.jmx.blueprint.codec.BPMetadata;
import org.apache.aries.jmx.blueprint.codec.BPNullMetadata;
import org.apache.aries.jmx.blueprint.codec.BPPropsMetadata;
import org.apache.aries.jmx.blueprint.codec.BPRefMetadata;
import org.apache.aries.jmx.blueprint.codec.BPReferenceListMetadata;
import org.apache.aries.jmx.blueprint.codec.BPReferenceMetadata;
import org.apache.aries.jmx.blueprint.codec.BPServiceMetadata;
import org.apache.aries.jmx.blueprint.codec.BPValueMetadata;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.IdRefMetadata;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;

public class Util {
    public static BPMetadata metadata2BPMetadata(Metadata metadata) {
        if (null == metadata) {
            return null;
        }
        if (metadata instanceof BeanMetadata) {
            return new BPBeanMetadata((BeanMetadata)metadata);
        }
        if (metadata instanceof ReferenceMetadata) {
            return new BPReferenceMetadata((ReferenceMetadata)metadata);
        }
        if (metadata instanceof RefMetadata) {
            return new BPRefMetadata((RefMetadata)metadata);
        }
        if (metadata instanceof CollectionMetadata) {
            return new BPCollectionMetadata((CollectionMetadata)metadata);
        }
        if (metadata instanceof ServiceMetadata) {
            return new BPServiceMetadata((ServiceMetadata)metadata);
        }
        if (metadata instanceof ReferenceListMetadata) {
            return new BPReferenceListMetadata((ReferenceListMetadata)metadata);
        }
        if (metadata instanceof IdRefMetadata) {
            return new BPIdRefMetadata((IdRefMetadata)metadata);
        }
        if (metadata instanceof MapMetadata) {
            return new BPMapMetadata((MapMetadata)metadata);
        }
        if (metadata instanceof PropsMetadata) {
            return new BPPropsMetadata((PropsMetadata)metadata);
        }
        if (metadata instanceof ValueMetadata) {
            return new BPValueMetadata((ValueMetadata)metadata);
        }
        if (metadata instanceof NullMetadata) {
            return new BPNullMetadata((NullMetadata)metadata);
        }
        throw new RuntimeException("Unknown metadata type");
    }

    public static BPMetadata binary2BPMetadata(byte[] buf) {
        CompositeData metadata;
        if (null == buf) {
            return null;
        }
        ByteArrayInputStream inBytes = new ByteArrayInputStream(buf);
        try {
            ObjectInputStream inObject = new ObjectInputStream(inBytes);
            metadata = (CompositeData)inObject.readObject();
            inObject.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        String typename = metadata.getCompositeType().getTypeName();
        if (typename.equals("BeanMetadata")) {
            return new BPBeanMetadata(metadata);
        }
        if (typename.equals("ReferenceMetadata")) {
            return new BPReferenceMetadata(metadata);
        }
        if (typename.equals("RefMetadata")) {
            return new BPRefMetadata(metadata);
        }
        if (typename.equals("CollectionMetadata")) {
            return new BPCollectionMetadata(metadata);
        }
        if (typename.equals("ServiceMetadata")) {
            return new BPServiceMetadata(metadata);
        }
        if (typename.equals("ReferenceListMetadata")) {
            return new BPReferenceListMetadata(metadata);
        }
        if (typename.equals("IdRefMetadata")) {
            return new BPIdRefMetadata(metadata);
        }
        if (typename.equals("MapMetadata")) {
            return new BPMapMetadata(metadata);
        }
        if (typename.equals("PropsMetadata")) {
            return new BPPropsMetadata(metadata);
        }
        if (typename.equals("ValueMetadata")) {
            return new BPValueMetadata(metadata);
        }
        if (metadata instanceof NullMetadata) {
            return new BPNullMetadata(metadata);
        }
        throw new RuntimeException("Unknown metadata type");
    }

    public static byte[] bpMetadata2Binary(BPMetadata metadata) {
        if (null == metadata) {
            return null;
        }
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outObject = new ObjectOutputStream(outBytes);
            outObject.writeObject(metadata.asCompositeData());
            outObject.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outBytes.toByteArray();
    }

    public static Byte[] bpMetadata2BoxedBinary(BPMetadata metadata) {
        if (null == metadata) {
            return null;
        }
        byte[] src = Util.bpMetadata2Binary(metadata);
        Byte[] res = new Byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            res[i] = src[i];
        }
        return res;
    }

    public static BPMetadata boxedBinary2BPMetadata(Byte[] buf) {
        if (null == buf) {
            return null;
        }
        byte[] unbox = new byte[buf.length];
        for (int i = 0; i < buf.length; ++i) {
            unbox[i] = buf[i];
        }
        return Util.binary2BPMetadata(unbox);
    }
}

