/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.io.InputStream;

public class ComboInputStream
extends InputStream {
    private boolean headDone;
    private InputStream head;
    private InputStream tail;

    public ComboInputStream(InputStream head, InputStream tail) {
        this.head = head != null ? head : tail;
        this.tail = tail != null ? tail : head;
    }

    public int read() throws IOException {
        int c;
        if (this.headDone) {
            c = this.tail.read();
        } else {
            c = this.head.read();
            if (c == -1) {
                this.headDone = true;
                c = this.tail.read();
            }
        }
        return c;
    }

    public int available() throws IOException {
        return this.tail.available() + this.head.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        try {
            this.head.close();
            Object var2_1 = null;
            if (this.head == this.tail) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.head == this.tail) throw throwable;
            this.tail.close();
            throw throwable;
        }
        this.tail.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int c;
        if (this.headDone) {
            c = this.tail.read(b, off, len);
        } else {
            c = this.head.read(b, off, len);
            if (c == -1) {
                this.headDone = true;
                c = this.tail.read(b, off, len);
            }
        }
        return c;
    }
}

