/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;

public abstract class Operator
extends SpelNodeImpl {
    private final String operatorName;

    public Operator(String payload, int pos, SpelNodeImpl ... operands) {
        super(pos, operands);
        this.operatorName = payload;
    }

    public SpelNodeImpl getLeftOperand() {
        return this.children[0];
    }

    public SpelNodeImpl getRightOperand() {
        return this.children[1];
    }

    public final String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getChild(0).toStringAST());
        for (int i = 1; i < this.getChildCount(); ++i) {
            sb.append(" ").append(this.getOperatorName()).append(" ");
            sb.append(this.getChild(i).toStringAST());
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean equalityCheck(ExpressionState state, Object left, Object right) {
        Class ancestor;
        if (left instanceof Number && right instanceof Number) {
            Number leftNumber = (Number)left;
            Number rightNumber = (Number)right;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal leftBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)leftNumber, BigDecimal.class);
                BigDecimal rightBigDecimal = (BigDecimal)NumberUtils.convertNumberToTargetClass((Number)rightNumber, BigDecimal.class);
                return leftBigDecimal == null ? rightBigDecimal == null : leftBigDecimal.compareTo(rightBigDecimal) == 0;
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return leftNumber.doubleValue() == rightNumber.doubleValue();
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                return leftNumber.floatValue() == rightNumber.floatValue();
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return leftNumber.longValue() == rightNumber.longValue();
            }
            return leftNumber.intValue() == rightNumber.intValue();
        }
        if (left instanceof CharSequence && right instanceof CharSequence) {
            return left.toString().equals(right.toString());
        }
        if (ObjectUtils.nullSafeEquals((Object)left, (Object)right)) {
            return true;
        }
        if (left instanceof Comparable && right instanceof Comparable && (ancestor = ClassUtils.determineCommonAncestor(left.getClass(), right.getClass())) != null && Comparable.class.isAssignableFrom(ancestor)) {
            return state.getTypeComparator().compare(left, right) == 0;
        }
        return false;
    }
}

