/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ReflectionHelper {
    static ArgumentsMatchInfo compareArguments(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((expectedArgTypes.size() == suppliedArgTypes.size() ? 1 : 0) != 0, (String)"Expected argument types and supplied argument types should be arrays of same length");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        for (int i = 0; i < expectedArgTypes.size() && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (expectedArg.equals((Object)suppliedArg)) continue;
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        return match != null ? new ArgumentsMatchInfo(match) : null;
    }

    public static int getTypeDifferenceWeight(List<TypeDescriptor> paramTypes, List<TypeDescriptor> argTypes) {
        int result = 0;
        for (int i = 0; i < paramTypes.size(); ++i) {
            TypeDescriptor paramType = paramTypes.get(i);
            TypeDescriptor argType = argTypes.get(i);
            if (argType == null) {
                if (!paramType.isPrimitive()) continue;
                return Integer.MAX_VALUE;
            }
            Class<Object> paramTypeClazz = paramType.getType();
            if (!ClassUtils.isAssignable((Class)paramTypeClazz, (Class)argType.getType())) {
                return Integer.MAX_VALUE;
            }
            if (paramTypeClazz.isPrimitive()) {
                paramTypeClazz = Object.class;
            }
            Class superClass = argType.getType().getSuperclass();
            while (superClass != null) {
                if (paramTypeClazz.equals(superClass)) {
                    result += 2;
                    superClass = null;
                    continue;
                }
                if (ClassUtils.isAssignable(paramTypeClazz, superClass)) {
                    result += 2;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
            if (!paramTypeClazz.isInterface()) continue;
            ++result;
        }
        return result;
    }

    static ArgumentsMatchInfo compareArgumentsVarargs(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((expectedArgTypes != null && expectedArgTypes.size() > 0 ? 1 : 0) != 0, (String)"Expected arguments must at least include one array (the vargargs parameter)");
        Assert.isTrue((boolean)expectedArgTypes.get(expectedArgTypes.size() - 1).isArray(), (String)"Final expected argument should be array type (the varargs parameter)");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        int argCountUpToVarargs = expectedArgTypes.size() - 1;
        for (int i = 0; i < argCountUpToVarargs && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals((Object)suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.size() != expectedArgTypes.size() || !expectedArgTypes.get(expectedArgTypes.size() - 1).equals((Object)suppliedArgTypes.get(suppliedArgTypes.size() - 1))) {
            TypeDescriptor varargsDesc = expectedArgTypes.get(expectedArgTypes.size() - 1);
            Class varargsParamType = varargsDesc.getElementTypeDescriptor().getType();
            for (int i = expectedArgTypes.size() - 1; i < suppliedArgTypes.size(); ++i) {
                TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
                if (suppliedArg == null) {
                    if (!varargsParamType.isPrimitive()) continue;
                    match = null;
                    continue;
                }
                if (varargsParamType == suppliedArg.getType()) continue;
                if (ClassUtils.isAssignable((Class)varargsParamType, (Class)suppliedArg.getType())) {
                    if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                    match = ArgumentsMatchKind.CLOSE;
                    continue;
                }
                match = typeConverter.canConvert(suppliedArg, TypeDescriptor.valueOf((Class)varargsParamType)) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
            }
        }
        return match != null ? new ArgumentsMatchInfo(match) : null;
    }

    static void convertArguments(TypeConverter converter, Object[] arguments, Object methodOrCtor, Integer varargsPosition) throws EvaluationException {
        if (varargsPosition == null) {
            for (int i = 0; i < arguments.length; ++i) {
                TypeDescriptor targetType = new TypeDescriptor(MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)i));
                Object argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
            }
        } else {
            Object argument;
            TypeDescriptor targetType;
            for (int i = 0; i < varargsPosition; ++i) {
                targetType = new TypeDescriptor(MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)i));
                argument = arguments[i];
                arguments[i] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
            }
            MethodParameter methodParam = MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)varargsPosition);
            if (varargsPosition == arguments.length - 1) {
                targetType = new TypeDescriptor(methodParam);
                argument = arguments[varargsPosition];
                arguments[varargsPosition.intValue()] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
            } else {
                targetType = new TypeDescriptor(methodParam).getElementTypeDescriptor();
                for (int i = varargsPosition.intValue(); i < arguments.length; ++i) {
                    Object argument2 = arguments[i];
                    arguments[i] = converter.convertValue(argument2, TypeDescriptor.forObject((Object)argument2), targetType);
                }
            }
        }
    }

    public static void convertAllArguments(TypeConverter converter, Object[] arguments, Method method) throws SpelEvaluationException {
        Integer varargsPosition = null;
        if (method.isVarArgs()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            varargsPosition = paramTypes.length - 1;
        }
        for (int argPos = 0; argPos < arguments.length; ++argPos) {
            TypeDescriptor targetType;
            if (varargsPosition != null && argPos >= varargsPosition) {
                MethodParameter methodParam = new MethodParameter(method, varargsPosition.intValue());
                targetType = TypeDescriptor.nested((MethodParameter)methodParam, (int)1);
            } else {
                targetType = new TypeDescriptor(new MethodParameter(method, argPos));
            }
            try {
                Object argument = arguments[argPos];
                if (argument == null || targetType.getObjectType().isInstance(argument)) continue;
                if (converter == null) {
                    throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, argument.getClass().getName(), targetType);
                }
                arguments[argPos] = converter.convertValue(argument, TypeDescriptor.forObject((Object)argument), targetType);
                continue;
            }
            catch (EvaluationException ex) {
                if (ex instanceof SpelEvaluationException) {
                    throw (SpelEvaluationException)ex;
                }
                throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, arguments[argPos].getClass().getName(), targetType);
            }
        }
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class<?>[] requiredParameterTypes, Object ... args) {
        int parameterCount = requiredParameterTypes.length;
        int argumentCount = args.length;
        if (parameterCount != args.length || requiredParameterTypes[parameterCount - 1] != (args[argumentCount - 1] != null ? args[argumentCount - 1].getClass() : null)) {
            int arraySize = 0;
            if (argumentCount >= parameterCount) {
                arraySize = argumentCount - (parameterCount - 1);
            }
            Object[] newArgs = new Object[parameterCount];
            System.arraycopy(args, 0, newArgs, 0, newArgs.length - 1);
            Class<?> componentType = requiredParameterTypes[parameterCount - 1].getComponentType();
            Object repackagedArgs = Array.newInstance(componentType, arraySize);
            for (int i = 0; i < arraySize; ++i) {
                Array.set(repackagedArgs, i, args[parameterCount - 1 + i]);
            }
            newArgs[newArgs.length - 1] = repackagedArgs;
            return newArgs;
        }
        return args;
    }

    static class ArgumentsMatchInfo {
        private final ArgumentsMatchKind kind;

        ArgumentsMatchInfo(ArgumentsMatchKind kind) {
            this.kind = kind;
        }

        public boolean isExactMatch() {
            return this.kind == ArgumentsMatchKind.EXACT;
        }

        public boolean isCloseMatch() {
            return this.kind == ArgumentsMatchKind.CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this.kind == ArgumentsMatchKind.REQUIRES_CONVERSION;
        }

        public String toString() {
            return "ArgumentMatchInfo: " + (Object)((Object)this.kind);
        }
    }

    static enum ArgumentsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;

    }
}

