/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.hibernate.validator.method.MethodValidator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.annotation.Validated;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private final MethodValidator validator;

    public MethodValidationInterceptor() {
        this(((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(validatorFactory.getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = (MethodValidator)validator.unwrap(MethodValidator.class);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class[] groups = this.determineValidationGroups(invocation);
        Set result = this.validator.validateAllParameters(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), groups);
        if (!result.isEmpty()) {
            throw new MethodConstraintViolationException(result);
        }
        Object returnValue = invocation.proceed();
        result = this.validator.validateReturnValue(invocation.getThis(), invocation.getMethod(), returnValue, groups);
        if (!result.isEmpty()) {
            throw new MethodConstraintViolationException(result);
        }
        return returnValue;
    }

    protected Class[] determineValidationGroups(MethodInvocation invocation) {
        Validated valid = (Validated)AnnotationUtils.findAnnotation(invocation.getThis().getClass(), Validated.class);
        return valid != null ? valid.value() : new Class[]{};
    }
}

