/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.undo;

import org.jledit.collection.RollingStack;
import org.jledit.command.undo.UndoableCommand;

public class UndoContext {
    private static final int DEFAULT_UNDO_DEPTH = 500;
    private Boolean everDirty = false;
    private final RollingStack<UndoableCommand> undoStack;
    private final RollingStack<UndoableCommand> redoStack;

    public UndoContext() {
        this(500);
    }

    public UndoContext(int size) {
        this.undoStack = new RollingStack(size);
        this.redoStack = new RollingStack(size);
    }

    public synchronized void undoPush(UndoableCommand item) {
        if (this.undoStack.getCapacity() == this.undoStack.size()) {
            this.everDirty = true;
        }
        this.undoStack.push(item);
    }

    public synchronized UndoableCommand undoPop() {
        return this.undoStack.pop();
    }

    public void redoPush(UndoableCommand item) {
        this.redoStack.push(item);
    }

    public UndoableCommand redoPop() {
        return this.redoStack.pop();
    }

    public Boolean isDirty() {
        return this.everDirty != false || this.undoStack.size() > 0;
    }

    public void clear() {
        this.everDirty = false;
        this.redoStack.clear();
        this.undoStack.clear();
    }
}

