/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command.completers;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Service
public class ConfigurationPropertyCompleter
implements Completer {
    private static final String OPTION = "-p";
    private static final String ALIAS = "--pid";
    @Reference
    private ConfigurationAdmin configAdmin;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        String pid;
        Set<String> propertyNames;
        StringsCompleter strings = new StringsCompleter();
        if (session != null && (propertyNames = this.getPropertyNames(pid = this.getPid(session, commandLine))) != null && !propertyNames.isEmpty()) {
            strings.getStrings().addAll(propertyNames);
        }
        return strings.complete(session, commandLine, candidates);
    }

    private String getPid(Session session, CommandLine commandLine) {
        String pid = (String)session.get("ConfigCommand.PID");
        if (commandLine.getArguments().length > 0) {
            int index;
            List<String> arguments = Arrays.asList(commandLine.getArguments());
            if (arguments.contains(OPTION)) {
                index = arguments.indexOf(OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
            if (arguments.contains(ALIAS)) {
                index = arguments.indexOf(ALIAS);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
        }
        return pid;
    }

    private Set<String> getPropertyNames(String pid) {
        HashSet<String> propertyNames = new HashSet<String>();
        if (pid != null) {
            Configuration configuration = null;
            try {
                Dictionary properties;
                Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=" + pid + ")");
                if (configs != null && configs.length > 0 && (configuration = configs[0]) != null && (properties = configuration.getProperties()) != null) {
                    Enumeration keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        propertyNames.add(String.valueOf(keys.nextElement()));
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
        return propertyNames;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

