/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.ops4j.net;

import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import shaded.org.ops4j.monitors.TooManyMonitorsException;
import shaded.org.ops4j.monitors.exception.ExceptionMonitor;
import shaded.org.ops4j.monitors.exception.ExceptionSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionCache
implements Runnable,
ExceptionSource {
    private static final Object DUMMY = new Object();
    private static ConnectionCache m_instance = new ConnectionCache();
    private HashMap<Object, Entry> m_hardStore = new HashMap();
    private WeakHashMap<URLConnection, Object> m_weakStore = new WeakHashMap();
    private long m_timeToLive = 30000L;
    private Thread m_thread;
    private ExceptionMonitor m_exceptionMonitor;

    private ConnectionCache() {
    }

    public static ConnectionCache getInstance() {
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection get(Object key) {
        ConnectionCache connectionCache = this;
        synchronized (connectionCache) {
            Entry entry = this.m_hardStore.get(key);
            if (entry == null) {
                return null;
            }
            return entry.m_connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object key, URLConnection conn) {
        ConnectionCache connectionCache = this;
        synchronized (connectionCache) {
            Entry entry = new Entry(conn);
            this.m_hardStore.put(key, entry);
            if (this.m_thread == null) {
                this.m_thread = new Thread((Runnable)this, "ConnectionCache-cleaner");
                this.m_thread.setDaemon(true);
                this.m_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ConnectionCache connectionCache = this;
                    synchronized (connectionCache) {
                        if (this.mainLoop()) {
                            return;
                        }
                    }
                }
            }
            catch (RuntimeException e) {
                if (this.m_exceptionMonitor == null) continue;
                this.m_exceptionMonitor.exception(this, e);
                continue;
            }
            catch (InterruptedException e) {
                if (this.m_exceptionMonitor == null) continue;
                this.m_exceptionMonitor.exception(this, e);
                continue;
            }
            break;
        }
    }

    private boolean mainLoop() throws InterruptedException {
        long now = System.currentTimeMillis();
        Iterator<Entry> list = this.m_hardStore.values().iterator();
        while (list.hasNext()) {
            Entry entry = list.next();
            if (entry.m_collectTime >= now) continue;
            this.m_weakStore.put(entry.m_connection, DUMMY);
            list.remove();
        }
        if (this.m_hardStore.size() == 0) {
            this.m_thread = null;
            return true;
        }
        this.wait(10000L);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerExceptionMonitor(ExceptionMonitor monitor) throws TooManyMonitorsException {
        ConnectionCache connectionCache = this;
        synchronized (connectionCache) {
            if (this.m_exceptionMonitor != null) {
                throw new TooManyMonitorsException(this, 1);
            }
            this.m_exceptionMonitor = monitor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterExceptionMonitor(ExceptionMonitor monitor) {
        ConnectionCache connectionCache = this;
        synchronized (connectionCache) {
            if (monitor == null || !monitor.equals(this.m_exceptionMonitor)) {
                return;
            }
            this.m_exceptionMonitor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExceptionMonitor> getExceptionMonitors() {
        ConnectionCache connectionCache = this;
        synchronized (connectionCache) {
            ArrayList<ExceptionMonitor> result = new ArrayList<ExceptionMonitor>();
            result.add(this.m_exceptionMonitor);
            return result;
        }
    }

    private class Entry {
        private URLConnection m_connection;
        private long m_collectTime;

        Entry(URLConnection conn) {
            this.m_connection = conn;
            this.m_collectTime = System.currentTimeMillis() + ConnectionCache.this.m_timeToLive;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(Entry.class)) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.m_connection.equals(other.m_connection);
        }

        public int hashCode() {
            return this.m_connection.hashCode();
        }

        public String toString() {
            return "Entry[" + this.m_connection + ", " + this.m_collectTime + "]";
        }
    }
}

