/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.DownloadBlocker;
import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.maven.support.Maven;
import aQute.bnd.osgi.Macro;
import aQute.bnd.osgi.Processor;
import aQute.bnd.resource.repository.ResourceRepositoryImpl;
import aQute.bnd.service.BndListener;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.action.Action;
import aQute.bnd.service.extension.ExtensionActivator;
import aQute.bnd.service.repository.SearchableRepository;
import aQute.bnd.url.MultiURLConnectionHandler;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.deployer.FileRepo;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.settings.Settings;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.naming.TimeLimitExceededException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace
extends Processor {
    static final int BUFFER_SIZE = 65536;
    public static final String BUILDFILE = "build.bnd";
    public static final String CNFDIR = "cnf";
    public static final String BNDDIR = "bnd";
    public static final String CACHEDIR = "cache";
    static Map<File, WeakReference<Workspace>> cache = Workspace.newHashMap();
    static Processor defaults = null;
    final Map<String, Project> models = Workspace.newHashMap();
    final Map<String, Action> commands = Workspace.newMap();
    final File buildDir;
    final Maven maven = new Maven(Processor.getExecutor());
    private boolean offline = true;
    Settings settings = new Settings();
    final ThreadLocal<Reporter> signalBusy = new ThreadLocal();
    private ResourceRepositoryImpl resourceRepositoryImpl;

    public static Project getProject(File projectDir) throws Exception {
        projectDir = projectDir.getAbsoluteFile();
        assert (projectDir.isDirectory());
        Workspace ws = Workspace.getWorkspace(projectDir.getParentFile());
        return ws.getProject(projectDir.getName());
    }

    public static synchronized Processor getDefaults() {
        if (defaults != null) {
            return defaults;
        }
        Properties props = new Properties();
        InputStream propStream = Workspace.class.getResourceAsStream("defaults.bnd");
        if (propStream != null) {
            try {
                props.load(propStream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to load bnd defaults.", e);
            }
            finally {
                IO.close(propStream);
            }
        } else {
            System.err.println("Cannot load defaults");
        }
        defaults = new Processor(props);
        return defaults;
    }

    public static Workspace getWorkspace(File parent) throws Exception {
        return Workspace.getWorkspace(parent, BNDDIR);
    }

    public static Workspace getWorkspaceWithoutException(File parent) throws Exception {
        try {
            return Workspace.getWorkspace(parent);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workspace getWorkspace(File parent, String bndDir) throws Exception {
        File workspaceDir = parent.getAbsoluteFile();
        while (workspaceDir.isDirectory()) {
            File test = new File(workspaceDir, CNFDIR);
            if (!test.exists()) {
                test = new File(workspaceDir, bndDir);
            }
            if (test.isDirectory()) break;
            if (test.isFile()) {
                String redirect = IO.collect(test).trim();
                workspaceDir = test = Workspace.getFile(test.getParentFile(), redirect).getAbsoluteFile();
            }
            if (test.exists()) continue;
            throw new IllegalArgumentException("No Workspace found from: " + parent);
        }
        Map<File, WeakReference<Workspace>> map = cache;
        synchronized (map) {
            Workspace ws;
            WeakReference<Workspace> wsr = cache.get(workspaceDir);
            if (wsr == null || (ws = (Workspace)wsr.get()) == null) {
                ws = new Workspace(workspaceDir, bndDir);
                cache.put(workspaceDir, new WeakReference<Workspace>(ws));
            }
            return ws;
        }
    }

    public Workspace(File dir) throws Exception {
        this(dir, BNDDIR);
    }

    public Workspace(File dir, String bndDir) throws Exception {
        super(Workspace.getDefaults());
        dir = dir.getAbsoluteFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Could not create directory " + dir);
        }
        assert (dir.isDirectory());
        File buildDir = new File(dir, bndDir).getAbsoluteFile();
        if (!buildDir.isDirectory()) {
            buildDir = new File(dir, CNFDIR).getAbsoluteFile();
        }
        this.buildDir = buildDir;
        File buildFile = new File(buildDir, BUILDFILE).getAbsoluteFile();
        if (!buildFile.isFile()) {
            this.warning("No Build File in " + dir, new Object[0]);
        }
        this.setProperties(buildFile, dir);
        this.propertiesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(String bsn) throws Exception {
        Map<String, Project> map = this.models;
        synchronized (map) {
            Project project = this.models.get(bsn);
            if (project != null) {
                return project;
            }
            File projectDir = this.getFile(bsn);
            project = new Project(this, projectDir);
            if (!project.isValid()) {
                return null;
            }
            this.models.put(bsn, project);
            return project;
        }
    }

    public boolean isPresent(String name) {
        return this.models.containsKey(name);
    }

    public Collection<Project> getCurrentProjects() {
        return this.models.values();
    }

    @Override
    public boolean refresh() {
        if (super.refresh()) {
            for (Project project : this.getCurrentProjects()) {
                project.propertiesChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        File extDir = new File(this.buildDir, "ext");
        File[] extensions = extDir.listFiles();
        if (extensions != null) {
            for (File extension : extensions) {
                String extensionName = extension.getName();
                if (!extensionName.endsWith(".bnd")) continue;
                extensionName = extensionName.substring(0, extensionName.length() - ".bnd".length());
                try {
                    this.doIncludeFile(extension, false, this.getProperties(), "ext." + extensionName);
                }
                catch (Exception e) {
                    this.error("PropertiesChanged: " + e.getMessage(), new Object[0]);
                }
            }
        }
    }

    public String _workspace(String[] args) {
        return this.getBase().getAbsolutePath();
    }

    public void addCommand(String menu, Action action) {
        this.commands.put(menu, action);
    }

    public void removeCommand(String menu) {
        this.commands.remove(menu);
    }

    public void fillActions(Map<String, Action> all) {
        all.putAll(this.commands);
    }

    public Collection<Project> getAllProjects() throws Exception {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (File file : this.getBase().listFiles()) {
            if (!new File(file, "bnd.bnd").isFile()) continue;
            projects.add(this.getProject(file.getAbsoluteFile().getName()));
        }
        return projects;
    }

    public void changedFile(File f) {
        List<BndListener> listeners = this.getPlugins(BndListener.class);
        for (BndListener l : listeners) {
            try {
                this.offline = false;
                l.changed(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void bracket(boolean begin) {
        List<BndListener> listeners = this.getPlugins(BndListener.class);
        for (BndListener l : listeners) {
            try {
                if (begin) {
                    l.begin();
                    continue;
                }
                l.end();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(Reporter reporter) {
        if (this.signalBusy.get() != null) {
            return;
        }
        this.signalBusy.set(reporter);
        try {
            List<BndListener> listeners = this.getPlugins(BndListener.class);
            for (BndListener l : listeners) {
                try {
                    l.signal(this);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.signalBusy.set(null);
        }
    }

    @Override
    public void signal() {
        this.signal(this);
    }

    void copy(InputStream in, OutputStream out) throws Exception {
        byte[] data = new byte[65536];
        int size = in.read(data);
        while (size > 0) {
            out.write(data, 0, size);
            size = in.read(data);
        }
    }

    public void syncCache() throws Exception {
        CachedFileRepo cf = new CachedFileRepo();
        cf.init();
        cf.close();
    }

    public List<RepositoryPlugin> getRepositories() {
        return this.getPlugins(RepositoryPlugin.class);
    }

    public Collection<Project> getBuildOrder() throws Exception {
        ArrayList<Project> result = new ArrayList<Project>();
        for (Project project : this.getAllProjects()) {
            Collection<Project> dependsOn = project.getDependson();
            this.getBuildOrder(dependsOn, result);
            if (result.contains(project)) continue;
            result.add(project);
        }
        return result;
    }

    private void getBuildOrder(Collection<Project> dependsOn, List<Project> result) throws Exception {
        for (Project project : dependsOn) {
            Collection<Project> subProjects = project.getDependson();
            for (Project subProject : subProjects) {
                if (result.contains(subProject)) continue;
                result.add(subProject);
            }
            if (result.contains(project)) continue;
            result.add(project);
        }
    }

    public static Workspace getWorkspace(String path) throws Exception {
        File file = IO.getFile(new File(""), path);
        return Workspace.getWorkspace(file);
    }

    public Maven getMaven() {
        return this.maven;
    }

    @Override
    protected void setTypeSpecificPlugins(Set<Object> list) {
        try {
            super.setTypeSpecificPlugins(list);
            list.add(this);
            list.add(this.maven);
            list.add(this.settings);
            if (!Workspace.isTrue(this.getProperty("-nobuildincache"))) {
                list.add(new CachedFileRepo());
            }
            this.resourceRepositoryImpl = new ResourceRepositoryImpl();
            this.resourceRepositoryImpl.setCache(IO.getFile(this.getProperty(CACHEDIR, "~/.bnd/caches/shas")));
            this.resourceRepositoryImpl.setExecutor(Workspace.getExecutor());
            this.resourceRepositoryImpl.setIndexFile(this.getFile("cnf/repo.json"));
            this.resourceRepositoryImpl.setURLConnector(new MultiURLConnectionHandler(this));
            this.customize(this.resourceRepositoryImpl, null);
            list.add(this.resourceRepositoryImpl);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void addExtensions(Set<Object> list) {
        Parameters extensions = new Parameters(this.getProperty("-extension"));
        HashMap<DownloadBlocker, Attrs> blockers = new HashMap<DownloadBlocker, Attrs>();
        for (Map.Entry<String, Attrs> entry : extensions.entrySet()) {
            String bsn = Workspace.removeDuplicateMarker(entry.getKey());
            String stringRange = entry.getValue().get("version");
            this.trace("Adding extension %s-%s", bsn, stringRange);
            if (stringRange == null) {
                stringRange = Version.LOWEST.toString();
            } else if (!VersionRange.isVersionRange(stringRange)) {
                this.error("Invalid version range %s on extension %s", stringRange, bsn);
                continue;
            }
            try {
                SortedSet<SearchableRepository.ResourceDescriptor> matches = this.resourceRepositoryImpl.find(null, bsn, new VersionRange(stringRange));
                if (matches.isEmpty()) {
                    this.error("Extension %s;version=%s not found in base repo", bsn, stringRange);
                    continue;
                }
                DownloadBlocker blocker = new DownloadBlocker(this);
                blockers.put(blocker, entry.getValue());
                this.resourceRepositoryImpl.getResource(matches.last().id, blocker);
            }
            catch (Exception e) {
                this.error("Failed to load extension %s-%s, %s", bsn, stringRange, e);
            }
        }
        this.trace("Found extensions %s", blockers);
        for (Map.Entry<String, Attrs> entry : blockers.entrySet()) {
            try {
                String reason = ((DownloadBlocker)((Object)entry.getKey())).getReason();
                if (reason != null) {
                    this.error("Extension load failed: %s", reason);
                    continue;
                }
                URLClassLoader cl = new URLClassLoader(new URL[]{((DownloadBlocker)((Object)entry.getKey())).getFile().toURI().toURL()}, this.getClass().getClassLoader());
                Enumeration<URL> manifests = cl.getResources("META-INF/MANIFEST.MF");
                while (manifests.hasMoreElements()) {
                    Manifest m = new Manifest(manifests.nextElement().openStream());
                    Parameters activators = new Parameters(m.getMainAttributes().getValue("Extension-Activator"));
                    for (Map.Entry<String, Attrs> e : activators.entrySet()) {
                        try {
                            Class<?> c = cl.loadClass(e.getKey());
                            ExtensionActivator extensionActivator = (ExtensionActivator)c.newInstance();
                            this.customize(extensionActivator, entry.getValue());
                            List<?> plugins = extensionActivator.activate(this, entry.getValue());
                            list.add(extensionActivator);
                            if (plugins == null) continue;
                            for (Object plugin : plugins) {
                                list.add(plugin);
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.error("Loading extension %s, extension activator missing: %s (ignored)", entry, e.getKey());
                        }
                    }
                }
            }
            catch (Exception e) {
                this.error("failed to install extension %s due to %s", entry, e);
            }
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Workspace setOffline(boolean on) {
        this.offline = on;
        return this;
    }

    public String _global(String[] args) throws Exception {
        Macro.verifyCommand(args, "${global;<name>[;<default>]}, get a global setting from ~/.bnd/settings.json", null, 2, 3);
        String key = args[1];
        if (key.equals("key.public")) {
            return Hex.toHexString(this.settings.getPublicKey());
        }
        if (key.equals("key.private")) {
            return Hex.toHexString(this.settings.getPrivateKey());
        }
        String s = this.settings.get(key);
        if (s != null) {
            return s;
        }
        if (args.length == 3) {
            return args[2];
        }
        return null;
    }

    public Object _repodigests(String[] args) throws Exception {
        Macro.verifyCommand(args, "${repodigests;[;<repo names>]...}, get the repository digests", null, 1, 10000);
        List<RepositoryPlugin> repos = this.getRepositories();
        if (args.length > 1) {
            Iterator<RepositoryPlugin> it = repos.iterator();
            block2: while (it.hasNext()) {
                String name = it.next().getName();
                for (int i = 1; i < args.length; ++i) {
                    if (!name.equals(args[i])) continue;
                    it.remove();
                    continue block2;
                }
                it.remove();
            }
        }
        ArrayList<String> digests = new ArrayList<String>();
        for (RepositoryPlugin repo : repos) {
            try {
                Method m = repo.getClass().getMethod("getDigest", new Class[0]);
                byte[] digest = (byte[])m.invoke((Object)repo, new Object[0]);
                digests.add(Hex.toHexString(digest));
            }
            catch (Exception e) {
                if (args.length == 1) continue;
                this.error("Specified repo %s for digests is not found", repo.getName());
            }
        }
        return Workspace.join(digests, ",");
    }

    public static Run getRun(File file) throws Exception {
        if (!file.isFile()) {
            return null;
        }
        File projectDir = file.getParentFile();
        File workspaceDir = projectDir.getParentFile();
        if (!workspaceDir.isDirectory()) {
            return null;
        }
        Workspace ws = Workspace.getWorkspaceWithoutException(workspaceDir);
        if (ws == null) {
            return null;
        }
        return new Run(ws, projectDir, file);
    }

    @Override
    public void report(Map<String, Object> table) throws Exception {
        super.report(table);
        table.put("Workspace", this.toString());
        table.put("Plugins", this.getPlugins(Object.class));
        table.put("Repos", this.getRepositories());
        table.put("Projects in build order", this.getBuildOrder());
    }

    public File getCache(String name) {
        return Workspace.getFile(this.buildDir, "cache/" + name);
    }

    class CachedFileRepo
    extends FileRepo {
        final Lock lock;
        boolean inited;

        CachedFileRepo() {
            super(Workspace.CACHEDIR, Processor.getFile(Workspace.this.buildDir, "cache/repo"), false);
            this.lock = new ReentrantLock();
        }

        public String toString() {
            return "bnd-cache";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean init() throws Exception {
            if (!this.lock.tryLock(50L, TimeUnit.SECONDS)) {
                throw new TimeLimitExceededException("Cached File Repo is locked and can't acquire it");
            }
            try {
                if (super.init()) {
                    this.inited = true;
                    if (!this.root.exists() && !this.root.mkdirs()) {
                        throw new IOException("Could not create cache directory " + this.root);
                    }
                    if (!this.root.isDirectory()) {
                        throw new IllegalArgumentException("Cache directory " + this.root + " not a directory");
                    }
                    InputStream in = this.getClass().getResourceAsStream("/embedded-repo.jar");
                    if (in != null) {
                        this.unzip(in, this.root);
                    } else {
                        if (this.root.isDirectory() && this.root.list().length >= 2) {
                            Workspace.this.trace("Assuming I am in a bnd test ...  the embedded repo is missig but it exists on the file system", new Object[0]);
                            boolean bl = true;
                            return bl;
                        }
                        Workspace.this.error("Couldn't find embedded-repo.jar in bundle ", new Object[0]);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unzip(InputStream in, File dir) throws Exception {
            try {
                JarInputStream jin = new JarInputStream(in);
                JarEntry jentry = jin.getNextJarEntry();
                while (jentry != null) {
                    File dest;
                    if (!(jentry.isDirectory() || (dest = Processor.getFile(dir, jentry.getName())).isFile() && dest.lastModified() >= jentry.getTime() && jentry.getTime() > 0L)) {
                        File dp = dest.getParentFile();
                        if (!dp.exists() && !dp.mkdirs()) {
                            throw new IOException("Could not create directory " + dp);
                        }
                        FileOutputStream out = new FileOutputStream(dest);
                        try {
                            Workspace.this.copy(jin, out);
                        }
                        finally {
                            out.close();
                        }
                    }
                    jentry = jin.getNextJarEntry();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

