/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.env.PropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePropertySource
extends PropertySource<Object> {
    private Set<PropertySource<?>> propertySources = new LinkedHashSet();

    public CompositePropertySource(String name) {
        super(name);
    }

    @Override
    public Object getProperty(String name) {
        for (PropertySource<?> propertySource : this.propertySources) {
            Object candidate = propertySource.getProperty(name);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    public void addPropertySource(PropertySource<?> propertySource) {
        this.propertySources.add(propertySource);
    }

    @Override
    public String toString() {
        return String.format("%s [name='%s', propertySources=%s]", this.getClass().getSimpleName(), this.name, this.propertySources);
    }
}

