/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.terminal.SignalSupport;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.SignalListener;

public class SshTerminal
extends SignalSupport
implements Terminal {
    private Environment environment;
    private boolean echo;

    public SshTerminal(Environment environment) {
        this.environment = environment;
        this.environment.addSignalListener(new SignalListener(){

            public void signal(org.apache.sshd.server.Signal signal) {
                SshTerminal.this.signal(Signal.WINCH);
            }
        }, new org.apache.sshd.server.Signal[]{org.apache.sshd.server.Signal.WINCH});
        this.echo = environment.getPtyModes().containsKey(PtyMode.ECHO);
    }

    public String getType() {
        return (String)this.environment.getEnv().get("TERM");
    }

    public int getWidth() {
        int width = 0;
        try {
            width = Integer.valueOf((String)this.environment.getEnv().get("COLUMNS"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return width > 0 ? width : 80;
    }

    public int getHeight() {
        int height = 0;
        try {
            height = Integer.valueOf((String)this.environment.getEnv().get("LINES"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return height > 0 ? height : 24;
    }

    public boolean isAnsiSupported() {
        return true;
    }

    public boolean isEchoEnabled() {
        return this.echo;
    }

    public void setEchoEnabled(boolean enabled) {
        this.echo = enabled;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

