/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.karaf.management.JMXSecurityMBean;
import org.apache.karaf.management.KarafMBeanServerGuard;

public class JMXSecurityMBeanImpl
extends StandardMBean
implements JMXSecurityMBean {
    private MBeanServer mbeanServer;
    private KarafMBeanServerGuard guard;

    public JMXSecurityMBeanImpl() throws NotCompliantMBeanException {
        super(JMXSecurityMBean.class);
    }

    @Override
    public boolean canInvoke(String objectName) throws Exception {
        if (this.guard == null) {
            return true;
        }
        return this.guard.canInvoke(this.mbeanServer, new ObjectName(objectName));
    }

    @Override
    public boolean canInvoke(String objectName, String methodName) throws Exception {
        if (this.guard == null) {
            return true;
        }
        return this.guard.canInvoke(this.mbeanServer, new ObjectName(objectName), methodName);
    }

    @Override
    public boolean canInvoke(String objectName, String methodName, String[] argumentTypes) throws Exception {
        ObjectName on = new ObjectName(objectName);
        if (this.guard == null) {
            return true;
        }
        return this.guard.canInvoke(this.mbeanServer, on, methodName, argumentTypes);
    }

    @Override
    public TabularData canInvoke(Map<String, List<String>> bulkQuery) throws Exception {
        TabularDataSupport table = new TabularDataSupport(CAN_INVOKE_TABULAR_TYPE);
        for (Map.Entry<String, List<String>> entry : bulkQuery.entrySet()) {
            String objectName = entry.getKey();
            List<String> methods = entry.getValue();
            if (methods.size() == 0) {
                boolean res = this.canInvoke(objectName);
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, "", res});
                table.put(data);
                continue;
            }
            for (String method : methods) {
                ArrayList<String> argTypes;
                String name = this.parseMethodName(method, argTypes = new ArrayList<String>());
                boolean res = name.equals(method) ? this.canInvoke(objectName, name) : this.canInvoke(objectName, name, argTypes.toArray(new String[0]));
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, method, res});
                table.put(data);
            }
        }
        return table;
    }

    private String parseMethodName(String method, List<String> argTypes) {
        int index = (method = method.trim()).indexOf(40);
        if (index < 0) {
            return method;
        }
        String args = method.substring(index + 1, method.length() - 1);
        for (String arg : args.split(",")) {
            argTypes.add(arg);
        }
        return method.substring(0, index);
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public KarafMBeanServerGuard getGuard() {
        return this.guard;
    }

    public void setGuard(KarafMBeanServerGuard guard) {
        this.guard = guard;
    }
}

