/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4jv2;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.internal.FallbackLogFactory;

public class Log4jv2Logger
extends AbstractLogger {
    private static final String LOG4J_FQCN = Logger.class.getName();
    private volatile PaxLogger delegate;

    public Log4jv2Logger(String name, MessageFactory messageFactory, PaxLoggingManager paxLogging) {
        super(name, messageFactory);
        this.setPaxLoggingManager(paxLogging);
    }

    public void setPaxLoggingManager(PaxLoggingManager paxLoggingManager) {
        this.delegate = paxLoggingManager != null ? paxLoggingManager.getLogger(this.getName(), LOG4J_FQCN) : FallbackLogFactory.createFallbackLog(null, this.getName());
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        return this.getLevel().intLevel() >= level.intLevel();
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        return this.getLevel().intLevel() >= level.intLevel();
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        return this.getLevel().intLevel() >= level.intLevel();
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.getLevel().intLevel() >= level.intLevel();
    }

    @Override
    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.getLevel().intLevel() >= level.intLevel();
    }

    @Override
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        if (level.intLevel() >= Level.TRACE.intLevel()) {
            this.delegate.trace(message.getFormattedMessage(), t, fqcn);
        } else if (level.intLevel() >= Level.DEBUG.intLevel()) {
            this.delegate.debug(message.getFormattedMessage(), t, fqcn);
        } else if (level.intLevel() >= Level.INFO.intLevel()) {
            this.delegate.inform(message.getFormattedMessage(), t, fqcn);
        } else if (level.intLevel() >= Level.WARN.intLevel()) {
            this.delegate.warn(message.getFormattedMessage(), t, fqcn);
        } else if (level.intLevel() >= Level.ERROR.intLevel()) {
            this.delegate.error(message.getFormattedMessage(), t, fqcn);
        } else if (level.intLevel() >= Level.FATAL.intLevel()) {
            this.delegate.fatal(message.getFormattedMessage(), t, fqcn);
        }
    }

    @Override
    public Level getLevel() {
        switch (this.delegate.getLogLevel()) {
            case 0: {
                return Level.TRACE;
            }
            case 1: {
                return Level.DEBUG;
            }
            case 2: {
                return Level.INFO;
            }
            case 3: {
                return Level.WARN;
            }
            case 4: {
                return Level.ERROR;
            }
        }
        return Level.OFF;
    }
}

