/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.properties;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.util.StreamUtils;
import org.apache.karaf.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoEncryptionSupport
implements Runnable,
Closeable {
    private final Logger LOGGER = LoggerFactory.getLogger(AutoEncryptionSupport.class);
    private volatile boolean running = true;
    private EncryptionSupport encryptionSupport;
    private ExecutorService executor;

    public AutoEncryptionSupport(Map<String, Object> properties) {
        this.encryptionSupport = new EncryptionSupport(properties);
        this.executor = Executors.newSingleThreadExecutor(ThreadUtils.namedThreadFactory("encryption"));
        this.executor.execute(this);
    }

    @Override
    public void close() {
        this.running = false;
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        WatchService watchService = null;
        try {
            watchService = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(System.getProperty("karaf.etc"), new String[0]);
            dir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Path file = dir.resolve("users.properties");
            this.encryptedPassword(new Properties(file.toFile()));
            while (this.running) {
                try {
                    WatchKey key = watchService.poll(1L, TimeUnit.SECONDS);
                    if (key == null) continue;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent<?> ev = event;
                        Path name = dir.resolve((Path)ev.context());
                        if (!file.equals(name)) continue;
                        this.encryptedPassword(new Properties(file.toFile()));
                    }
                    key.reset();
                }
                catch (IOException e) {
                    this.LOGGER.warn(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            try {
                this.LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(watchService);
                throw throwable;
            }
            StreamUtils.close(watchService);
        }
        StreamUtils.close(watchService);
    }

    void encryptedPassword(Properties users) throws IOException {
        boolean changed = false;
        Iterator iterator = users.keySet().iterator();
        while (iterator.hasNext()) {
            String encryptedPassword;
            String[] infos;
            String storedPassword;
            String userName;
            String user = userName = (String)iterator.next();
            String userInfos = (String)users.get(user);
            if (user.startsWith("_g_:") || (storedPassword = (infos = userInfos.split(","))[0]).equals(encryptedPassword = this.encryptionSupport.encrypt(storedPassword))) continue;
            this.LOGGER.debug("The password isn't flagged as encrypted, encrypt it.");
            userInfos = encryptedPassword + ",";
            for (int i = 1; i < infos.length; ++i) {
                userInfos = i == infos.length - 1 ? userInfos + infos[i] : userInfos + infos[i] + ",";
            }
            if (user.contains("\\")) {
                users.remove(user);
                user = user.replace("\\", "\\\\");
            }
            users.put(user, userInfos);
            changed = true;
        }
        if (changed) {
            users.save();
        }
    }
}

