/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.osgi.service.log.LogService;

@Command(scope="log", name="log", description="Log a message.")
@Service
public class LogEntry
implements Action {
    @Argument(index=0, name="message", description="The message to log", required=true, multiValued=false)
    private String message;
    @Option(name="--level", aliases={"-l"}, description="The level the message will be logged at", required=false, multiValued=false)
    @Completion(value=StringsCompleter.class, values={"DEBUG", "INFO", "WARNING", "ERROR"})
    private String level = "INFO";
    @Reference
    LogService logService;
    private final Map<String, Integer> mappings = new HashMap<String, Integer>();

    public LogEntry() {
        this.mappings.put("ERROR", 1);
        this.mappings.put("WARNING", 2);
        this.mappings.put("INFO", 3);
        this.mappings.put("DEBUG", 4);
    }

    public Object execute() throws Exception {
        this.logService.log(this.toLevel(this.level.toUpperCase()), this.message);
        return null;
    }

    private int toLevel(String logLevel) {
        Integer level = this.mappings.get(logLevel);
        if (level == null) {
            level = 3;
        }
        return level;
    }
}

