/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolverImpl;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.framework.ContextFinder;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.XMLParsingServiceFactory;
import org.eclipse.osgi.internal.location.EquinoxLocations;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.internal.url.EquinoxFactoryManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.eclipse.osgi.storage.BundleLocalizationImpl;
import org.eclipse.osgi.storage.url.BundleURLConverter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.resolver.Resolver;
import org.osgi.service.startlevel.StartLevel;

public class SystemBundleActivator
implements BundleActivator {
    private EquinoxFactoryManager urlFactoryManager;
    private List<ServiceRegistration<?>> registrations = new ArrayList(10);
    private SecurityManager setSecurityManagner;

    @Override
    public void start(BundleContext bc) throws Exception {
        this.registrations.clear();
        EquinoxBundle bundle = (EquinoxBundle)bc.getBundle();
        bundle.getEquinoxContainer().systemStart(bc);
        EquinoxConfiguration configuration = bundle.getEquinoxContainer().getConfiguration();
        this.installSecurityManager(configuration);
        bundle.getEquinoxContainer().getLogServices().start(bc);
        this.urlFactoryManager = new EquinoxFactoryManager(bundle.getEquinoxContainer());
        this.urlFactoryManager.installHandlerFactories(bc);
        FrameworkDebugOptions dbgOptions = (FrameworkDebugOptions)configuration.getDebugOptions();
        dbgOptions.start(bc);
        SecurityAdmin sa = bundle.getEquinoxContainer().getStorage().getSecurityAdmin();
        ContextFinder tccl = bundle.getEquinoxContainer().getContextFinder();
        this.registerLocations(bc, bundle.getEquinoxContainer().getLocations());
        this.register(bc, EnvironmentInfo.class, bundle.getEquinoxContainer().getConfiguration(), null);
        this.register(bc, PackageAdmin.class, bundle.getEquinoxContainer().getPackageAdmin(), null);
        this.register(bc, StartLevel.class, bundle.getEquinoxContainer().getStartLevel(), null);
        this.register(bc, PermissionAdmin.class, sa, null);
        this.register(bc, ConditionalPermissionAdmin.class, sa, null);
        Hashtable<String, Object> props = new Hashtable<String, Object>(7);
        props.clear();
        props.put("service.ranking", Integer.MIN_VALUE);
        this.register(bc, Resolver.class, (Object)new ResolverImpl(new Logger(0), null), false, props);
        this.register(bc, DebugOptions.class, dbgOptions, null);
        if (tccl != null) {
            props.clear();
            props.put("equinox.classloader.type", "contextClassLoader");
            this.register(bc, ClassLoader.class, tccl, props);
        }
        props.clear();
        props.put("protocol", new String[]{"bundleentry", "bundleresource"});
        this.register(bc, URLConverter.class, new BundleURLConverter(), props);
        this.register(bc, BundleLocalization.class, new BundleLocalizationImpl(), null);
        boolean setTccl = "true".equals(bundle.getEquinoxContainer().getConfiguration().getConfiguration("eclipse.parsers.setTCCL", "true"));
        try {
            this.register(bc, "javax.xml.parsers.SAXParserFactory", (Object)new XMLParsingServiceFactory(true, setTccl), false, null);
            this.register(bc, "javax.xml.parsers.DocumentBuilderFactory", (Object)new XMLParsingServiceFactory(false, setTccl), false, null);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        bundle.getEquinoxContainer().getStorage().getExtensionInstaller().startExtensionActivators(bc);
        props.clear();
        props.put("listener.symbolic.name", "org.eclipse.osgi");
        this.register(bc, DebugOptionsListener.class, bundle.getEquinoxContainer().getConfiguration().getDebug(), props);
        this.register(bc, DebugOptionsListener.class, bundle.getModule().getContainer(), props);
    }

    private void installSecurityManager(EquinoxConfiguration configuration) throws BundleException {
        SecurityManager sm;
        String securityManager = configuration.getConfiguration("org.osgi.framework.security");
        if (System.getSecurityManager() != null && securityManager != null) {
            throw new BundleException("Cannot specify the \"org.osgi.framework.security\" configuration property when a security manager is already installed.");
        }
        if (securityManager == null) {
            securityManager = configuration.getConfiguration("eclipse.security", configuration.getProperty("java.security.manager"));
        }
        if (securityManager != null && (sm = System.getSecurityManager()) == null) {
            if (securityManager.length() == 0) {
                sm = new SecurityManager();
            } else if (securityManager.equals("osgi")) {
                sm = new EquinoxSecurityManager();
            } else {
                try {
                    Class<?> clazz = Class.forName(securityManager);
                    sm = (SecurityManager)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            if (sm == null) {
                throw new NoClassDefFoundError(securityManager);
            }
            if (configuration.getDebug().DEBUG_SECURITY) {
                Debug.println("Setting SecurityManager to: " + sm);
            }
            System.setSecurityManager(sm);
            this.setSecurityManagner = sm;
            return;
        }
    }

    private void registerLocations(BundleContext bc, EquinoxLocations equinoxLocations) {
        Hashtable<String, Object> locationProperties = new Hashtable<String, Object>(1);
        Location location = equinoxLocations.getUserLocation();
        if (location != null) {
            ((Dictionary)locationProperties).put("type", "osgi.user.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getInstanceLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "osgi.instance.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getConfigurationLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "osgi.configuration.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getInstallLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "osgi.install.area");
            this.register(bc, Location.class, location, locationProperties);
        }
        if ((location = equinoxLocations.getEclipseHomeLocation()) != null) {
            ((Dictionary)locationProperties).put("type", "eclipse.home.location");
            this.register(bc, Location.class, location, locationProperties);
        }
    }

    @Override
    public void stop(BundleContext bc) throws Exception {
        EquinoxBundle bundle = (EquinoxBundle)bc.getBundle();
        bundle.getEquinoxContainer().getStorage().getExtensionInstaller().stopExtensionActivators(bc);
        FrameworkDebugOptions dbgOptions = (FrameworkDebugOptions)bundle.getEquinoxContainer().getConfiguration().getDebugOptions();
        dbgOptions.stop(bc);
        this.urlFactoryManager.uninstallHandlerFactories();
        for (ServiceRegistration<?> registration : this.registrations) {
            registration.unregister();
        }
        this.registrations.clear();
        bundle.getEquinoxContainer().getLogServices().stop(bc);
        this.unintallSecurityManager();
        bundle.getEquinoxContainer().systemStop(bc);
    }

    private void unintallSecurityManager() {
        if (this.setSecurityManagner != null && System.getSecurityManager() == this.setSecurityManagner) {
            System.setSecurityManager(null);
        }
        this.setSecurityManagner = null;
    }

    private void register(BundleContext context, Class<?> serviceClass, Object service, Dictionary<String, Object> properties) {
        this.register(context, serviceClass.getName(), service, true, properties);
    }

    private void register(BundleContext context, Class<?> serviceClass, Object service, boolean setRanking, Dictionary<String, Object> properties) {
        this.register(context, serviceClass.getName(), service, setRanking, properties);
    }

    private void register(BundleContext context, String serviceClass, Object service, boolean setRanking, Dictionary<String, Object> properties) {
        if (properties == null) {
            properties = new Hashtable<String, Object>(7);
        }
        Dictionary<String, String> headers = context.getBundle().getHeaders();
        properties.put("service.vendor", headers.get("Bundle-Vendor"));
        if (setRanking) {
            properties.put("service.ranking", Integer.MAX_VALUE);
        }
        properties.put("service.pid", String.valueOf(context.getBundle().getBundleId()) + "." + service.getClass().getName());
        this.registrations.add(context.registerService(serviceClass, service, properties));
    }
}

