/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.core.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpCookie;
import java.net.URI;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final Logger LOGGER;
    protected String proxyTo;
    protected boolean doForwardIP = true;
    protected boolean doSendUrlFragment = true;
    private HttpClient proxyClient;
    protected static final HeaderGroup hopByHopHeaders;
    protected static final BitSet asciiQueryChars;

    public void setIPForwarding(boolean ipForwarding) {
        this.doForwardIP = ipForwarding;
    }

    public void setProxyTo(String proxyTo) {
        this.proxyTo = proxyTo;
    }

    public String getServletInfo() {
        return "Apache Karaf Proxy Servlet";
    }

    public void init() throws ServletException {
        BasicHttpParams hcParams = new BasicHttpParams();
        hcParams.setParameter("http.protocol.cookie-policy", "ignoreCookies");
        this.proxyClient = this.createHttpClient(hcParams);
    }

    protected HttpClient createHttpClient(HttpParams hcParams) {
        try {
            Class<?> clientClazz = Class.forName("og.apache.http.impl.client.SystemDefaultHttpClient");
            Constructor<?> constructor = clientClazz.getConstructor(HttpParams.class);
            return (HttpClient)constructor.newInstance(hcParams);
        }
        catch (ClassNotFoundException clientClazz) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new DefaultHttpClient(new ThreadSafeClientConnManager(), hcParams);
    }

    public void destroy() {
        if (this.proxyClient instanceof Closeable) {
            try {
                ((Closeable)((Object)this.proxyClient)).close();
            }
            catch (IOException e) {
                this.log("Error occurred when closing HTTP client in the proxy servlet destroy", e);
            }
        } else if (this.proxyClient != null) {
            this.proxyClient.getConnectionManager().shutdown();
        }
        super.destroy();
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        BasicHttpRequest proxyRequest;
        URI locationUri = URI.create(this.proxyTo);
        HttpHost host = URIUtils.extractHost(locationUri);
        LOGGER.debug("Proxy to {} (host {})", (Object)locationUri, (Object)host);
        String method = servletRequest.getMethod();
        String proxyRequestUri = this.rewriteUrlFromRequest(servletRequest, this.proxyTo);
        if (servletRequest.getHeader("Content-Length") != null || servletRequest.getHeader("Transfer-Encoding") != null) {
            BasicHttpEntityEnclosingRequest entityProxyRequest = new BasicHttpEntityEnclosingRequest(method, proxyRequestUri);
            entityProxyRequest.setEntity(new InputStreamEntity((InputStream)servletRequest.getInputStream(), servletRequest.getContentLength()));
            proxyRequest = entityProxyRequest;
        } else {
            proxyRequest = new BasicHttpRequest(method, proxyRequestUri);
        }
        this.copyRequestHeaders(servletRequest, proxyRequest, host);
        this.setXForwardedForHeader(servletRequest, proxyRequest);
        HttpResponse proxyResponse = null;
        try {
            proxyResponse = this.proxyClient.execute(host, proxyRequest);
            int statusCode = proxyResponse.getStatusLine().getStatusCode();
            this.copyResponseHeaders(proxyResponse, servletRequest, servletResponse);
            if (this.doResponseRedirect(servletRequest, servletResponse, proxyResponse, statusCode, this.proxyTo)) {
                return;
            }
            servletResponse.setStatus(statusCode, proxyResponse.getStatusLine().getReasonPhrase());
            this.copyResponseEntity(proxyResponse, servletResponse);
        }
        catch (Exception e) {
            if (proxyRequest instanceof AbortableHttpRequest) {
                AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)((Object)proxyRequest);
                abortableHttpRequest.abort();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServletException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (proxyResponse != null) {
                this.consumeQuietly(proxyResponse.getEntity());
            }
        }
    }

    protected boolean doResponseRedirect(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpResponse proxyResponse, int statusCode, String proxyTo) throws ServletException, IOException {
        if (statusCode >= 300 && statusCode < 304) {
            Header locationHeader = proxyResponse.getLastHeader("Location");
            if (locationHeader != null) {
                throw new ServletException("Received a redirect (" + statusCode + ") but without location (" + "Location" + " header)");
            }
            String locationString = this.rewriteUrlFromResponse(servletRequest, locationHeader.getValue(), proxyTo);
            servletResponse.sendRedirect(locationString);
            return true;
        }
        if (statusCode == 304) {
            servletResponse.setIntHeader("Content-Length", 0);
            servletResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
        }
    }

    protected void consumeQuietly(HttpEntity httpEntity) {
        try {
            EntityUtils.consume(httpEntity);
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
        }
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest, HttpHost host) {
        Enumeration headerNames = servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase("Host")) {
                    headerValue = host.getHostName();
                    if (host.getPort() != -1) {
                        headerValue = headerValue + ":" + host.getPort();
                    }
                } else if (headerName.equalsIgnoreCase("Cookie")) {
                    headerValue = this.getRealCookie(headerValue);
                }
                proxyRequest.addHeader(headerName, headerValue);
            }
        }
    }

    private void setXForwardedForHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        if (this.doForwardIP) {
            String newHeader = servletRequest.getRemoteAddr();
            String existingHeader = servletRequest.getHeader("X-Forwarded-For");
            if (existingHeader != null) {
                newHeader = existingHeader + ", " + newHeader;
            }
            proxyRequest.setHeader("X-Forwarded-For", newHeader);
        }
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            if (header.getName().equalsIgnoreCase("Set-Cookie") || header.getName().equalsIgnoreCase("Set-Cookie2")) {
                this.copyProxyCookie(servletRequest, servletResponse, header);
                continue;
            }
            servletResponse.setHeader(header.getName(), header.getValue());
        }
    }

    protected void copyProxyCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Header header) {
        List<HttpCookie> cookies = HttpCookie.parse(header.getValue());
        String path = servletRequest.getContextPath();
        path = path + servletRequest.getServletPath();
        for (HttpCookie cookie : cookies) {
            String proxyCookieName = this.getCookieNamePrefix() + cookie.getName();
            Cookie servletCookie = new Cookie(proxyCookieName, cookie.getValue());
            servletCookie.setComment(cookie.getComment());
            servletCookie.setMaxAge((int)cookie.getMaxAge());
            servletCookie.setPath(path);
            servletCookie.setSecure(cookie.getSecure());
            servletCookie.setVersion(cookie.getVersion());
            servletResponse.addCookie(servletCookie);
        }
    }

    protected String getRealCookie(String cookieValue) {
        String[] cookies;
        StringBuilder escapedCookie = new StringBuilder();
        for (String cookie : cookies = cookieValue.split("; ")) {
            String cookieName;
            String[] cookieSplit = cookie.split("=");
            if (cookieSplit.length == 2 && (cookieName = cookieSplit[0]).startsWith(this.getCookieNamePrefix())) {
                cookieName = cookieName.substring(this.getCookieNamePrefix().length());
                if (escapedCookie.length() > 0) {
                    escapedCookie.append("; ");
                }
                escapedCookie.append(cookieName).append("=").append(cookieSplit[1]);
            }
            cookieValue = escapedCookie.toString();
        }
        return cookieValue;
    }

    protected String getCookieNamePrefix() {
        return "!Proxy!" + this.getServletConfig().getServletName();
    }

    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            entity.writeTo((OutputStream)servletOutputStream);
        }
    }

    protected String rewriteUrlFromRequest(HttpServletRequest servletRequest, String location) {
        int fragIdx;
        StringBuilder uri = new StringBuilder(500);
        uri.append(location);
        if (servletRequest.getPathInfo() != null) {
            uri.append(ProxyServlet.encodeUriQuery(servletRequest.getPathInfo()));
        }
        String queryString = servletRequest.getQueryString();
        String fragment = null;
        if (queryString != null && (fragIdx = queryString.indexOf(35)) >= 0) {
            fragment = queryString.substring(fragIdx + 1);
            queryString = queryString.substring(0, fragIdx);
        }
        if ((queryString = this.rewriteQueryStringFromRequest(servletRequest, queryString)) != null && queryString.length() > 0) {
            uri.append('?');
            uri.append(ProxyServlet.encodeUriQuery(queryString));
        }
        if (this.doSendUrlFragment && fragment != null) {
            uri.append('#');
            uri.append(ProxyServlet.encodeUriQuery(fragment));
        }
        return uri.toString();
    }

    protected String rewriteQueryStringFromRequest(HttpServletRequest servletRequest, String queryString) {
        return queryString;
    }

    protected String rewriteUrlFromResponse(HttpServletRequest servletRequest, String theUrl, String location) {
        if (theUrl.startsWith(location)) {
            String curUrl = servletRequest.getRequestURL().toString();
            String pathInfo = servletRequest.getPathInfo();
            if (pathInfo != null) {
                assert (curUrl.endsWith(pathInfo));
                curUrl = curUrl.substring(0, curUrl.length() - pathInfo.length());
            }
            theUrl = curUrl + theUrl.substring(location.length());
        }
        return theUrl;
    }

    protected static CharSequence encodeUriQuery(CharSequence in) {
        CharSequence outBuf = null;
        Formatter formatter = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (asciiQueryChars.get(c)) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf == null) {
                outBuf = new StringBuilder(in.length() + 15);
                ((StringBuilder)outBuf).append(in, 0, i);
                formatter = new Formatter((Appendable)((Object)outBuf));
            }
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        String[] headers;
        LOGGER = LoggerFactory.getLogger(ProxyServlet.class);
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader(new BasicHeader(header, null));
        }
        char[] c_unreserved = "_-!.~'()*".toCharArray();
        char[] c_punct = ",;:$&+=".toCharArray();
        char[] c_reserved = "?/[]@".toCharArray();
        asciiQueryChars = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (char c2 : c_unreserved) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_punct) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_reserved) {
            asciiQueryChars.set(c2);
        }
        asciiQueryChars.set(37);
    }
}

