/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.http.core.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.karaf.http.core.ProxyService;
import org.apache.karaf.http.core.internal.ProxyServlet;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceImpl
implements ProxyService {
    private static Logger LOG = LoggerFactory.getLogger((String)ProxyServiceImpl.class.getName());
    protected static final String CONFIGURATION_PID = "org.apache.karaf.http";
    protected static final String CONFIGURATION_KEY = "proxies";
    private ConfigurationAdmin configurationAdmin;
    private HttpService httpService;
    private Map<String, String> proxies;

    public ProxyServiceImpl(HttpService httpService, ConfigurationAdmin configurationAdmin) {
        this.httpService = httpService;
        this.configurationAdmin = configurationAdmin;
        this.proxies = new HashMap<String, String>();
        this.initProxies();
    }

    @Override
    public Map<String, String> getProxies() {
        return this.proxies;
    }

    @Override
    public void addProxy(String url, String proxyTo) throws Exception {
        this.addProxyInternal(url, proxyTo);
        this.updateConfiguration();
    }

    @Override
    public void removeProxy(String url) throws Exception {
        LOG.debug("removing proxy alias: " + url);
        this.httpService.unregister(url);
        this.proxies.remove(url);
        this.updateConfiguration();
    }

    @Override
    public void initProxies() {
        LOG.debug("unregistering and registering all configured proxies");
        this.unregisterAllProxies();
        this.initProxiesInternal();
    }

    private void initProxiesInternal() {
        try {
            Configuration configuration = this.getConfiguration();
            Dictionary configurationProperties = configuration.getProperties();
            String[] proxiesArray = this.getConfiguredProxyArray(configurationProperties);
            if (proxiesArray != null) {
                for (String proxyPair : proxiesArray) {
                    String[] split = proxyPair.split(" ", 2);
                    if (split.length != 2) continue;
                    String from = split[0].trim();
                    String to = split[1].trim();
                    if (from.length() <= 0 || to.length() <= 0) continue;
                    this.addProxyInternal(from, to);
                }
            }
        }
        catch (Exception e) {
            LOG.error("unable to initialize proxies: " + e.getMessage());
        }
    }

    private void addProxyInternal(String url, String proxyTo) {
        LOG.debug("adding proxy alias: " + url + ", proxied to: " + proxyTo);
        try {
            ProxyServlet proxyServlet = new ProxyServlet();
            proxyServlet.setProxyTo(proxyTo);
            this.httpService.registerServlet(url, (Servlet)proxyServlet, new Hashtable(), null);
            this.proxies.put(url, proxyTo);
        }
        catch (Exception e) {
            LOG.error("could not add proxy alias: " + url + ", proxied to: " + proxyTo + ", reason: " + e.getMessage());
        }
    }

    private void updateConfiguration() {
        try {
            Configuration configuration = this.getConfiguration();
            Hashtable<String, String[]> configurationProperties = configuration.getProperties();
            if (configurationProperties == null) {
                configurationProperties = new Hashtable<String, String[]>();
            }
            ((Dictionary)configurationProperties).put(CONFIGURATION_KEY, this.mapToProxyArray(this.proxies));
            configuration.update(configurationProperties);
        }
        catch (Exception e) {
            LOG.error("unable to update http proxy from configuration: " + e.getMessage());
        }
    }

    private Configuration getConfiguration() {
        try {
            return this.configurationAdmin.getConfiguration(CONFIGURATION_PID, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving http proxy information from config admin", e);
        }
    }

    private String[] mapToProxyArray(Map<String, String> proxies) {
        ArrayList<String> proxyList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : proxies.entrySet()) {
            proxyList.add(entry.getKey() + " " + entry.getValue());
        }
        return (String[])proxyList.stream().toArray(String[]::new);
    }

    private String[] getConfiguredProxyArray(Dictionary<String, Object> configurationProperties) {
        Object val = null;
        if (configurationProperties != null) {
            val = configurationProperties.get(CONFIGURATION_KEY);
        }
        if (val instanceof String[]) {
            return (String[])val;
        }
        return null;
    }

    private void unregisterAllProxies() {
        for (String url : this.proxies.keySet()) {
            LOG.debug("removing proxy alias: " + url);
            this.httpService.unregister(url);
        }
        this.proxies.clear();
    }
}

