/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.ops4j.pax.web.extender.war.internal.RegisterWebAppVisitorHS;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.WebAppWebContainerContext;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppCookieConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspPropertyGroup;
import org.ops4j.pax.web.extender.war.internal.model.WebAppJspServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppSecurityConstraint;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServletContainerInitializer;
import org.ops4j.pax.web.extender.war.internal.model.WebAppTagLib;
import org.ops4j.pax.web.service.WebAppDependencyHolder;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegisterWebAppVisitorWC
implements WebAppVisitor {
    private static final String REGISTRATION_EXCEPTION_SKIPPING = "Registration exception. Skipping.";
    private static final Logger LOG = LoggerFactory.getLogger(RegisterWebAppVisitorWC.class);
    private final WebContainer webContainer;
    private HttpContext httpContext;
    private ClassLoader bundleClassLoader;
    private WebAppDependencyHolder dependencyHolder;

    RegisterWebAppVisitorWC(WebAppDependencyHolder dependencyHolder) {
        NullArgumentException.validateNotNull(dependencyHolder, "Web container");
        this.dependencyHolder = dependencyHolder;
        this.webContainer = (WebContainer)dependencyHolder.getHttpService();
    }

    @Override
    public void visit(WebApp webApp) {
        WebAppCookieConfig scc;
        if (LOG.isDebugEnabled()) {
            LOG.debug("visiting webapp: {}", (Object)webApp);
        }
        NullArgumentException.validateNotNull(webApp, "Web app");
        this.bundleClassLoader = new BundleClassLoader(webApp.getBundle());
        Set wiredBundles = ClassPathUtil.getBundlesInClassSpace((Bundle)webApp.getBundle(), new LinkedHashSet());
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        bundles.add(webApp.getBundle());
        bundles.addAll(wiredBundles);
        this.bundleClassLoader = new ResourceDelegatingBundleClassLoader(bundles);
        this.httpContext = new WebAppWebContainerContext(this.webContainer.createDefaultHttpContext(), webApp.getRootPath(), webApp.getBundle(), webApp.getMimeMappings());
        webApp.setHttpContext(this.httpContext);
        try {
            this.webContainer.setContextParam(RegisterWebAppVisitorHS.convertInitParams(webApp.getContextParams()), this.httpContext);
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
        if (webApp.getLoginConfigs() != null) {
            for (WebAppLoginConfig loginConfig : webApp.getLoginConfigs()) {
                this.visit(loginConfig);
            }
        }
        if (webApp.getSessionTimeout() != null) {
            try {
                this.webContainer.setSessionTimeout(Integer.valueOf(Integer.parseInt(webApp.getSessionTimeout())), this.httpContext);
            }
            catch (Exception ignore) {
                LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
            }
        }
        if ((scc = webApp.getSessionCookieConfig()) != null) {
            this.webContainer.setSessionCookieConfig(scc.getDomain(), scc.getName(), scc.getHttpOnly(), scc.getSecure(), scc.getPath(), scc.getMaxAge(), this.httpContext);
        }
        for (WebAppServletContainerInitializer servletContainerInitializer : webApp.getServletContainerInitializers()) {
            this.webContainer.registerServletContainerInitializer(servletContainerInitializer.getServletContainerInitializer(), (Class[])servletContainerInitializer.getClasses(), this.httpContext);
        }
        ServletContainerInitializer initializer = this.dependencyHolder.getServletContainerInitializer();
        if (initializer != null) {
            this.webContainer.registerServletContainerInitializer(initializer, null, this.httpContext);
        }
        this.webContainer.setConnectorsAndVirtualHosts(webApp.getConnectorList(), webApp.getVirtualHostList(), this.httpContext);
        if (webApp.getJettyWebXmlURL() != null) {
            this.webContainer.registerJettyWebXml(webApp.getJettyWebXmlURL(), this.httpContext);
        }
        LOG.debug("webcontainer begin!");
        this.webContainer.begin(this.httpContext);
        LOG.debug("registering welcome files");
        try {
            String[] welcomeFiles = webApp.getWelcomeFiles();
            if (welcomeFiles != null && welcomeFiles.length > 0) {
                this.webContainer.registerWelcomeFiles(welcomeFiles, true, this.httpContext);
            }
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
        LOG.debug("registering default resources");
        try {
            this.webContainer.registerResources("/", "default", this.httpContext);
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
        LOG.debug("registering jsps");
        try {
            this.webContainer.registerJsps(new String[]{"*.jsp", "*.jspx", "*.jspf", "*.xsp", "*.JSP", "*.JSPX", "*.JSPF", "*.XSP"}, this.httpContext);
        }
        catch (UnsupportedOperationException ignore) {
            LOG.warn(ignore.getMessage());
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
        WebAppJspConfig jspConfigDescriptor = webApp.getJspConfigDescriptor();
        if (jspConfigDescriptor != null) {
            for (WebAppTagLib webAppTagLib : jspConfigDescriptor.getTagLibConfigs()) {
                this.webContainer.registerJspConfigTagLibs(webAppTagLib.getTagLibLocation(), webAppTagLib.getTagLibUri(), this.httpContext);
            }
            for (WebAppJspPropertyGroup webAppJspPropertyGroup : jspConfigDescriptor.getJspPropertyGroups()) {
                Boolean elIgnored = webAppJspPropertyGroup.getElIgnored();
                List<String> includeCodes = webAppJspPropertyGroup.getIncludeCodes();
                List<String> includePreludes = webAppJspPropertyGroup.getIncludePreludes();
                Boolean isXml = webAppJspPropertyGroup.getIsXml();
                Boolean scriptingInvalid = webAppJspPropertyGroup.getScriptingInvalid();
                List<String> urlPatterns = webAppJspPropertyGroup.getUrlPatterns();
                this.webContainer.registerJspConfigPropertyGroup(includeCodes, includePreludes, urlPatterns, elIgnored, scriptingInvalid, isXml, this.httpContext);
            }
        }
    }

    @Override
    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull(webAppServlet, "Web app servlet");
        String[] urlPatterns = webAppServlet.getAliases();
        if (urlPatterns == null || urlPatterns.length == 0) {
            LOG.warn("Servlet [" + webAppServlet + "] does not have any mapping. Skipped.");
        }
        try {
            if (webAppServlet instanceof WebAppJspServlet) {
                this.webContainer.registerJspServlet(urlPatterns, this.httpContext, ((WebAppJspServlet)webAppServlet).getJspPath());
            } else {
                Class<Servlet> servletClass = RegisterWebAppVisitorHS.loadClass(Servlet.class, this.bundleClassLoader, webAppServlet.getServletClassName());
                this.webContainer.registerServlet(servletClass, urlPatterns, RegisterWebAppVisitorHS.convertInitParams(webAppServlet.getInitParams()), Integer.valueOf(webAppServlet.getLoadOnStartup()), webAppServlet.getAsyncSupported(), webAppServlet.getMultipartConfig(), this.httpContext);
            }
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppFilter webAppFilter) {
        NullArgumentException.validateNotNull(webAppFilter, "Web app filter");
        LOG.debug("registering filter: {}", (Object)webAppFilter);
        String[] urlPatterns = webAppFilter.getUrlPatterns();
        String[] servletNames = webAppFilter.getServletNames();
        if (!(urlPatterns != null && urlPatterns.length != 0 || servletNames != null && servletNames.length != 0)) {
            LOG.warn("Filter [" + webAppFilter + "] does not have any mapping. Skipped.");
        }
        boolean asyncSupported = false;
        if (webAppFilter.getAsyncSupported() != null) {
            asyncSupported = webAppFilter.getAsyncSupported();
        }
        try {
            String filterName = webAppFilter.getFilterName();
            Class<Filter> filterClass = RegisterWebAppVisitorHS.loadClass(Filter.class, this.bundleClassLoader, webAppFilter.getFilterClass());
            webAppFilter.setFilterClass(filterClass);
            Dictionary<String, String> initParams = RegisterWebAppVisitorHS.convertInitParams(webAppFilter.getInitParams());
            DispatcherType[] dispatcherTypes = webAppFilter.getDispatcherTypes().toArray(new DispatcherType[webAppFilter.getDispatcherTypes().size()]);
            StringBuilder dispatcherTypeString = new StringBuilder();
            for (int i = 0; i < dispatcherTypes.length; ++i) {
                dispatcherTypeString.append(dispatcherTypes[i].name());
                if (i >= dispatcherTypes.length) continue;
                dispatcherTypeString.append(",");
            }
            initParams.put("filter-mapping-dispatcher", dispatcherTypeString.toString());
            initParams.put("filter-name", filterName);
            this.webContainer.registerFilter(filterClass, urlPatterns, servletNames, initParams, asyncSupported, this.httpContext);
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppListener webAppListener) {
        NullArgumentException.validateNotNull(webAppListener, "Web app listener");
        try {
            EventListener listener = RegisterWebAppVisitorHS.newInstance(EventListener.class, this.bundleClassLoader, webAppListener.getListenerClass());
            webAppListener.setListener(listener);
            this.webContainer.registerEventListener(listener, this.httpContext);
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppErrorPage webAppErrorPage) {
        NullArgumentException.validateNotNull(webAppErrorPage, "Web app error page");
        try {
            this.webContainer.registerErrorPage(webAppErrorPage.getError(), webAppErrorPage.getLocation(), this.httpContext);
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppLoginConfig loginConfig) {
        NullArgumentException.validateNotNull(loginConfig, "Web app login config");
        try {
            this.webContainer.registerLoginConfig(loginConfig.getAuthMethod(), loginConfig.getRealmName(), loginConfig.getFormLoginPage(), loginConfig.getFormErrorPage(), this.httpContext);
        }
        catch (Exception ignore) {
            LOG.error(REGISTRATION_EXCEPTION_SKIPPING, (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppConstraintMapping constraintMapping) {
        NullArgumentException.validateNotNull(constraintMapping, "Web app constraint mappings");
        try {
            WebAppSecurityConstraint securityConstraint = constraintMapping.getSecurityConstraint();
            this.webContainer.registerConstraintMapping(constraintMapping.getConstraintName(), constraintMapping.getMapping(), constraintMapping.getUrl(), securityConstraint.getDataConstraint(), securityConstraint.getAuthenticate(), securityConstraint.getRoles(), this.httpContext);
        }
        catch (Exception ignore) {
            LOG.error("Registration exception. Skipping", (Throwable)ignore);
        }
    }

    @Override
    public void end() {
        this.webContainer.end(this.httpContext);
    }
}

