/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.felix.utils.repository.BaseRepository;
import org.apache.felix.utils.resource.CapabilityImpl;
import org.apache.felix.utils.resource.RequirementImpl;
import org.apache.felix.utils.resource.ResourceImpl;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.region.AbstractRegionDigraphVisitor;
import org.apache.karaf.features.internal.region.CandidateComparator;
import org.apache.karaf.features.internal.region.Subsystem;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.apache.karaf.features.internal.resolver.ResourceUtils;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolveContext;

public class SubsystemResolveContext
extends ResolveContext {
    private final Subsystem root;
    private final Map<String, Region> regions;
    private final Map<Resource, Integer> distance;
    private final CandidateComparator candidateComparator = new CandidateComparator(this::getResourceCost);
    private final Map<Resource, Subsystem> resToSub = new HashMap<Resource, Subsystem>();
    private final Repository repository;
    private final Repository globalRepository;
    private final Downloader downloader;
    private final FeaturesService.ServiceRequirementsBehavior serviceRequirements;

    public SubsystemResolveContext(Subsystem root, RegionDigraph digraph, Repository globalRepository, Downloader downloader, FeaturesService.ServiceRequirementsBehavior serviceRequirements) {
        this.root = root;
        this.globalRepository = globalRepository != null ? new SubsystemRepository(globalRepository) : null;
        this.downloader = downloader;
        this.serviceRequirements = serviceRequirements;
        this.prepare(root);
        this.repository = new BaseRepository(this.resToSub.keySet());
        this.regions = new HashMap<String, Region>();
        for (Region region : digraph) {
            this.regions.put(region.getName(), region);
        }
        this.distance = this.computeDistances(root);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getGlobalRepository() {
        return this.globalRepository;
    }

    private Map<Resource, Integer> computeDistances(Resource root) {
        HashMap<Resource, Integer> distance = new HashMap<Resource, Integer>();
        HashSet<Resource> settledNodes = new HashSet<Resource>();
        distance.put(root, 0);
        ArrayList<Resource> unSettledNodes = new ArrayList<Resource>();
        unSettledNodes.add(root);
        while (!unSettledNodes.isEmpty()) {
            unSettledNodes.sort(Comparator.comparingInt(r -> distance.getOrDefault(r, Integer.MAX_VALUE)));
            Resource node = (Resource)unSettledNodes.remove(0);
            if (!settledNodes.add(node)) continue;
            Map<Resource, Integer> edge = this.computeEdges(node);
            for (Resource target : edge.keySet()) {
                int d = distance.getOrDefault(node, Integer.MAX_VALUE) + edge.get(target);
                distance.merge(target, d, Math::min);
                if (settledNodes.contains(target)) continue;
                unSettledNodes.add(target);
            }
        }
        return distance;
    }

    private Map<Resource, Integer> computeEdges(Resource resource) {
        HashMap<Resource, Integer> edges = new HashMap<Resource, Integer>();
        String owner = ResolverUtil.getOwnerName(resource);
        for (Requirement req : resource.getRequirements(null)) {
            if (SubsystemResolveContext.isOptional(req) || SubsystemResolveContext.isDynamic(req)) continue;
            List<Capability> caps = this.findProviders(req);
            for (Capability cap : caps) {
                Resource r = cap.getResource();
                int v = caps.size() == 1 ? 0 : (Objects.equals(ResolverUtil.getOwnerName(r), owner) ? 1 : 10);
                edges.merge(r, v, Math::min);
            }
        }
        return edges;
    }

    private int getResourceCost(Resource resource) {
        return this.distance.getOrDefault(resource, Integer.MAX_VALUE);
    }

    static boolean isOptional(Requirement req) {
        String resolution = (String)req.getDirectives().get("resolution");
        return "optional".equals(resolution);
    }

    static boolean isDynamic(Requirement req) {
        String resolution = (String)req.getDirectives().get("resolution");
        return "dynamic".equals(resolution);
    }

    void prepare(Subsystem subsystem) {
        this.resToSub.put(subsystem, subsystem);
        for (Resource res : subsystem.getInstallable()) {
            this.resToSub.put(res, subsystem);
        }
        for (Subsystem child : subsystem.getChildren()) {
            this.prepare(child);
        }
    }

    public Collection<Resource> getMandatoryResources() {
        return Collections.singleton(this.root);
    }

    public List<Capability> findProviders(Requirement requirement) {
        ArrayList<Capability> caps = new ArrayList<Capability>();
        Region requirerRegion = this.getRegion(requirement.getResource());
        if (requirerRegion != null) {
            Collection<Capability> res;
            Map<Requirement, Collection<Capability>> resMap = this.repository.findProviders(Collections.singleton(requirement));
            Collection<Capability> collection = res = resMap != null ? resMap.get(requirement) : null;
            if (res != null && !res.isEmpty()) {
                caps.addAll(res);
            } else if (this.globalRepository != null && !"optional".equals(requirement.getDirectives().get("resolution"))) {
                resMap = this.globalRepository.findProviders(Collections.singleton(requirement));
                Collection<Capability> collection2 = res = resMap != null ? resMap.get(requirement) : null;
                if (res != null && !res.isEmpty()) {
                    caps.addAll(res);
                }
            }
            Visitor visitor = new Visitor(caps);
            requirerRegion.visitSubgraph(visitor);
            Collection allowed = visitor.getAllowed();
            caps.retainAll(allowed);
            if (caps.size() > 1) {
                HashSet<Resource> providers = new HashSet<Resource>();
                for (Capability cap2 : caps) {
                    Resource resource = cap2.getResource();
                    String id = ResolverUtil.getSymbolicName(resource) + "|" + ResolverUtil.getVersion(resource);
                    if (providers.contains(resource)) continue;
                    HashSet oldRes = new HashSet(providers);
                    providers.clear();
                    String r1 = this.getRegion(resource).getName();
                    boolean superceded = false;
                    for (Resource r : oldRes) {
                        String id2 = ResolverUtil.getSymbolicName(r) + "|" + ResolverUtil.getVersion(r);
                        if (id.equals(id2)) {
                            String r2 = this.getRegion(r).getName();
                            if (r1.equals(r2)) {
                                if (r instanceof BundleRevision) {
                                    providers.add(r);
                                    superceded = true;
                                    continue;
                                }
                                if (resource instanceof BundleRevision) {
                                    providers.add(resource);
                                    continue;
                                }
                                throw new InternalError();
                            }
                            if (r1.startsWith(r2)) {
                                providers.add(r);
                                superceded = true;
                                continue;
                            }
                            if (r2.startsWith(r1)) {
                                providers.add(resource);
                                continue;
                            }
                            providers.add(r);
                            continue;
                        }
                        providers.add(r);
                    }
                    if (superceded) continue;
                    providers.add(resource);
                }
                caps.removeIf(cap -> !providers.contains(cap.getResource()));
            }
            if (this.distance != null && caps.size() > 1) {
                caps.sort(this.candidateComparator);
            }
        }
        return caps;
    }

    private Subsystem getSubsystem(Resource resource) {
        return this.resToSub.get(resource);
    }

    private Region getRegion(Resource resource) {
        return this.regions.get(this.getSubsystem(resource).getName());
    }

    public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
        int idx = Collections.binarySearch(capabilities, hostedCapability, this.candidateComparator);
        if (idx < 0) {
            idx = Math.abs(idx + 1);
        }
        capabilities.add(idx, (Capability)hostedCapability);
        return idx;
    }

    public boolean isEffective(Requirement requirement) {
        boolean isServiceReq = "osgi.service".equals(requirement.getNamespace());
        return !isServiceReq || FeaturesService.ServiceRequirementsBehavior.Disable != this.serviceRequirements;
    }

    public Map<Resource, Wiring> getWirings() {
        return Collections.emptyMap();
    }

    class SubsystemRepository
    implements Repository {
        private final Repository repository;
        private final Map<Subsystem, Map<Capability, Capability>> mapping = new HashMap<Subsystem, Map<Capability, Capability>>();

        public SubsystemRepository(Repository repository) {
            this.repository = repository;
        }

        @Override
        public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
            Map<Requirement, Collection<Capability>> base = this.repository.findProviders(requirements);
            HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
            for (Map.Entry<Requirement, Collection<Capability>> entry : base.entrySet()) {
                ArrayList<Capability> caps = new ArrayList<Capability>();
                Subsystem ss = SubsystemResolveContext.this.getSubsystem(entry.getKey().getResource());
                while (!ss.isAcceptDependencies()) {
                    ss = ss.getParent();
                }
                Map map = this.mapping.computeIfAbsent(ss, k -> new HashMap());
                for (Capability cap : entry.getValue()) {
                    Capability wrapped = (Capability)map.get(cap);
                    if (wrapped == null) {
                        this.wrap(map, ss, cap.getResource());
                        wrapped = (Capability)map.get(cap);
                    }
                    caps.add(wrapped);
                }
                result.put(entry.getKey(), caps);
            }
            return result;
        }

        private void wrap(Map<Capability, Capability> map, Subsystem subsystem, Resource resource) {
            ResourceImpl wrapped = new ResourceImpl();
            for (Capability cap : resource.getCapabilities(null)) {
                CapabilityImpl wCap = new CapabilityImpl(wrapped, cap.getNamespace(), cap.getDirectives(), cap.getAttributes());
                map.put(cap, wCap);
                wrapped.addCapability(wCap);
            }
            for (Requirement req : resource.getRequirements(null)) {
                RequirementImpl wReq = new RequirementImpl(wrapped, req.getNamespace(), req.getDirectives(), req.getAttributes());
                wrapped.addRequirement(wReq);
            }
            ResourceUtils.addIdentityRequirement(wrapped, subsystem, false);
            SubsystemResolveContext.this.resToSub.put(wrapped, subsystem);
            try {
                SubsystemResolveContext.this.downloader.download(ResourceUtils.getUri(wrapped), null);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unable to download resource: " + ResourceUtils.getUri(wrapped));
            }
        }
    }

    class Visitor
    extends AbstractRegionDigraphVisitor<Capability> {
        Visitor(Collection<Capability> candidates) {
            super(candidates);
        }

        @Override
        protected boolean contains(Region region, Capability candidate) {
            return region.equals(SubsystemResolveContext.this.getRegion(candidate.getResource()));
        }

        @Override
        protected boolean isAllowed(Capability candidate, RegionFilter filter) {
            if (filter.isAllowed(candidate.getNamespace(), candidate.getAttributes())) {
                return true;
            }
            Resource resource = candidate.getResource();
            List identities = resource.getCapabilities("osgi.identity");
            if (identities != null && !identities.isEmpty()) {
                Capability identity = (Capability)identities.iterator().next();
                HashMap attrs = new HashMap();
                attrs.put("bundle-symbolic-name", identity.getAttributes().get("osgi.identity"));
                attrs.put("bundle-version", identity.getAttributes().get("version"));
                return filter.isAllowed("org.eclipse.equinox.allow.bundle", attrs);
            }
            return false;
        }
    }
}

