/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

public final class IpChecker {
    private IpChecker() {
    }

    public static boolean matches(String pExpected, String pToCheck) {
        String[] parts = pExpected.split("/", 2);
        if (parts.length == 1) {
            IpChecker.convertToIntTuple(pExpected);
            IpChecker.convertToIntTuple(pToCheck);
            return pExpected.equals(pToCheck);
        }
        if (parts.length == 2) {
            int[] ipToCheck = IpChecker.convertToIntTuple(pToCheck);
            int[] ipPattern = IpChecker.convertToIntTuple(parts[0]);
            int[] netmask = parts[1].length() <= 2 ? IpChecker.transformCidrToNetmask(parts[1]) : IpChecker.convertToIntTuple(parts[1]);
            for (int i = 0; i < ipToCheck.length; ++i) {
                if ((ipPattern[i] & netmask[i]) == (ipToCheck[i] & netmask[i])) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("Invalid IP adress specification " + pExpected);
    }

    private static int[] transformCidrToNetmask(String pCidrString) {
        try {
            int i;
            int pCidr = Integer.parseInt(pCidrString);
            if (pCidr < 0 || pCidr > 32) {
                throw new IllegalArgumentException("Invalid netmask specification " + pCidr);
            }
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < pCidr; ++i) {
                buf.append("1");
            }
            for (i = pCidr; i < 32; ++i) {
                buf.append("0");
            }
            int[] ret = new int[4];
            int start = 0;
            int end = 8;
            for (int j = 0; j < 4; ++j) {
                ret[j] = Integer.parseInt(buf.substring(start, end), 2);
                start += 8;
                end += 8;
            }
            return ret;
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Invalid netmask specification " + pCidrString, exp);
        }
    }

    private static int[] convertToIntTuple(String pAddress) {
        String[] parts = pAddress.split("\\.");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid IP-Adresse " + pAddress);
        }
        int[] ret = new int[4];
        for (int i = 0; i < 4; ++i) {
            try {
                ret[i] = Integer.parseInt(parts[i]);
                if (ret[i] >= 0 && ret[i] <= 255) continue;
                throw new IllegalArgumentException("Invalid IP-Adresse " + pAddress);
            }
            catch (NumberFormatException exp) {
                throw new IllegalArgumentException("Invalid IP-Adresse " + pAddress, exp);
            }
        }
        return ret;
    }
}

