/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebAppMimeMapping;
import org.ops4j.pax.web.extender.war.internal.util.Path;
import org.ops4j.pax.web.utils.ClassPathUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebAppHttpContext
implements HttpContext {
    static final URL NO_URL;
    protected final HttpContext httpContext;
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final Bundle bundle;
    final String rootPath;
    private final Map<String, String> mimeMappings;
    private final ConcurrentMap<String, URL> resourceCache = new ConcurrentHashMap<String, URL>();

    WebAppHttpContext(HttpContext httpContext, String rootPath, Bundle bundle, WebAppMimeMapping[] webAppMimeMappings) {
        NullArgumentException.validateNotNull(httpContext, "http context");
        NullArgumentException.validateNotNull(bundle, "Bundle");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating WebAppHttpContext for {}", (Object)httpContext);
        }
        this.httpContext = httpContext;
        this.rootPath = rootPath;
        this.bundle = bundle;
        this.mimeMappings = new HashMap<String, String>();
        for (WebAppMimeMapping mimeMapping : webAppMimeMappings) {
            this.mimeMappings.put(mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.httpContext.handleSecurity(request, response);
    }

    public URL getResource(String name) {
        String normalizedName = Path.normalizeResourcePath(this.rootPath + (name.startsWith("/") ? "" : "/") + name).trim();
        this.log.debug("Searching bundle " + this.bundle + " for resource [{}], normalized to [{}]", (Object)name, (Object)normalizedName);
        URL url = (URL)this.resourceCache.get(normalizedName);
        if (url == null && !normalizedName.isEmpty()) {
            url = this.bundle.getEntry(normalizedName);
            if (url == null) {
                Bundle bundleInClassSpace;
                this.log.debug("getEntry failed, trying with /META-INF/resources/ in bundle class space");
                Set bundlesInClassSpace = ClassPathUtil.getBundlesInClassSpace((Bundle)this.bundle, new HashSet());
                Iterator iterator = bundlesInClassSpace.iterator();
                while (iterator.hasNext() && (url = (bundleInClassSpace = (Bundle)iterator.next()).getEntry("/META-INF/resources/" + normalizedName)) == null) {
                }
            }
            if (url == null) {
                this.log.debug("getEntry failed, fallback to getResource");
                url = this.bundle.getResource(normalizedName);
            }
            if (url == null) {
                url = NO_URL;
            }
            this.resourceCache.putIfAbsent(normalizedName, url);
        }
        if (url != null && url != NO_URL) {
            this.log.debug("Resource found as url [{}]", (Object)url);
        } else {
            this.log.debug("Resource not found");
            url = null;
        }
        return url;
    }

    public String getMimeType(String name) {
        String mimeType = null;
        if (name != null && name.length() > 0 && name.contains(".")) {
            String[] segments = name.split("\\.");
            mimeType = this.mimeMappings.get(segments[segments.length - 1]);
        }
        if (mimeType == null) {
            mimeType = this.httpContext.getMimeType(name);
        }
        return mimeType;
    }

    public String toString() {
        return "WebAppHttpContext{" + this.bundle.getSymbolicName() + " - " + this.bundle.getBundleId() + '}';
    }

    static {
        try {
            NO_URL = new URL("http:");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

