/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerImpl;
import org.ops4j.pax.web.service.jetty.internal.NIOSocketConnectorWrapper;
import org.ops4j.pax.web.service.jetty.internal.SocketConnectorWrapper;
import org.ops4j.pax.web.service.spi.model.ServerModel;

class JettyFactoryImpl
implements JettyFactory {
    private final ServerModel m_serverModel;

    JettyFactoryImpl(ServerModel serverModel) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.m_serverModel = serverModel;
    }

    public JettyServer createServer() {
        return new JettyServerImpl(this.m_serverModel);
    }

    public Connector createConnector(int port, String host, boolean useNIO) {
        if (useNIO) {
            NIOSocketConnectorWrapper nioConnector = new NIOSocketConnectorWrapper();
            nioConnector.setHost(host);
            nioConnector.setPort(port);
            nioConnector.setUseDirectBuffers(true);
            return nioConnector;
        }
        SocketConnectorWrapper connector = new SocketConnectorWrapper();
        connector.setPort(port);
        connector.setHost(host);
        return connector;
    }

    public Connector createSecureConnector(int port, String sslKeystore, String sslPassword, String sslKeyPassword, String host, String sslKeystoreType, boolean isClientAuthNeeded, boolean isClientAuthWanted) {
        SslSocketConnector connector = new SslSocketConnector();
        connector.setPort(port);
        connector.setKeystore(sslKeystore);
        connector.setPassword(sslPassword);
        connector.setKeyPassword(sslKeyPassword);
        connector.setHost(host);
        connector.setNeedClientAuth(isClientAuthNeeded);
        connector.setWantClientAuth(isClientAuthWanted);
        if (sslKeystoreType != null) {
            connector.setKeystoreType(sslKeystoreType);
        }
        return connector;
    }
}

