/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesBackingEngine
implements BackingEngine {
    private final Logger logger = LoggerFactory.getLogger(PropertiesBackingEngine.class);
    private Properties users;
    private EncryptionSupport encryptionSupport;

    public PropertiesBackingEngine(Properties users) {
        this.users = users;
    }

    public PropertiesBackingEngine(Properties users, EncryptionSupport encryptionSupport) {
        this.users = users;
        this.encryptionSupport = encryptionSupport;
    }

    @Override
    public void addUser(String username, String password) {
        String userInfos;
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String newPassword = password;
        if (this.encryptionSupport != null && this.encryptionSupport.getEncryption() != null) {
            newPassword = this.encryptionSupport.getEncryption().encryptPassword(password);
            if (this.encryptionSupport.getEncryptionPrefix() != null) {
                newPassword = this.encryptionSupport.getEncryptionPrefix() + newPassword;
            }
            if (this.encryptionSupport.getEncryptionSuffix() != null) {
                newPassword = newPassword + this.encryptionSupport.getEncryptionSuffix();
            }
        }
        if ((userInfos = (String)this.users.get(username)) != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            userInfoBuffer.append(newPassword);
            for (int i = 1; i < infos.length; ++i) {
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        } else {
            this.users.put(username, newPassword);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            this.logger.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public void deleteUser(String username) {
        this.users.remove(username);
        try {
            this.users.save();
        }
        catch (Exception ex) {
            this.logger.error("Cannot remove users file,", (Throwable)ex);
        }
    }

    @Override
    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> result = new ArrayList<UserPrincipal>();
        Set userSet = this.users.keySet();
        for (String userNames : userSet) {
            UserPrincipal userPrincipal = new UserPrincipal(userNames);
            result.add(userPrincipal);
        }
        return result;
    }

    @Override
    public List<RolePrincipal> listRoles(UserPrincipal user) {
        ArrayList<RolePrincipal> result = new ArrayList<RolePrincipal>();
        String userInfo = (String)this.users.get(user.getName());
        String[] infos = userInfo.split(",");
        for (int i = 1; i < infos.length; ++i) {
            result.add(new RolePrincipal(infos[i]));
        }
        return result;
    }

    @Override
    public void addRole(String username, String role) {
        String userInfos = (String)this.users.get(username);
        if (userInfos != null) {
            for (RolePrincipal rp : this.listRoles(new UserPrincipal(username))) {
                if (!role.equals(rp.getName())) continue;
                return;
            }
            String newUserInfos = userInfos + "," + role;
            this.users.put(username, newUserInfos);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            this.logger.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public void deleteRole(String username, String role) {
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String userInfos = (String)this.users.get(username);
        if (userInfos != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            String password = infos[0];
            userInfoBuffer.append(password);
            for (int i = 1; i < infos.length; ++i) {
                if (infos[i] == null || infos[i].equals(role)) continue;
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            this.logger.error("Cannot update users file,", (Throwable)ex);
        }
    }
}

