/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.jline;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.console.jline.DelayedStarted;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.local.AgentImpl;
import org.fusesource.jansi.AnsiConsole;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleFactory.class);
    BundleContext bundleContext;
    private CommandProcessor commandProcessor;
    private TerminalFactory terminalFactory;
    Console console;
    private boolean start;
    private ServiceRegistration registration;
    private SshAgent local;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public synchronized void registerCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = commandProcessor;
        this.start();
    }

    public synchronized void unregisterCommandProcessor(CommandProcessor commandProcessor) throws Exception {
        this.commandProcessor = null;
        this.stop();
    }

    public void setTerminalFactory(TerminalFactory terminalFactory) {
        this.terminalFactory = terminalFactory;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    protected void start() throws Exception {
        if (this.start) {
            Subject subject = new Subject();
            String user = "karaf";
            subject.getPrincipals().add((Principal)new UserPrincipal("karaf"));
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConsoleFactory.this.doStart("karaf");
                    return null;
                }
            });
        }
    }

    public static Object invokePrivateMethod(Object o, String methodName, Object[] params) throws Exception {
        Method[] methods = o.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            methods[i].setAccessible(true);
            return methods[i].invoke(o, params);
        }
        return null;
    }

    private static <T> T unwrapBIS(T stream) {
        try {
            return (T)ConsoleFactory.invokePrivateMethod(stream, "getInIfOpen", null);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    protected void doStart(String user) throws Exception {
        String agentId = this.startAgent(user);
        final Terminal terminal = this.terminalFactory.getTerminal();
        InputStream unwrappedIn = ConsoleFactory.unwrapBIS(ConsoleFactory.unwrap(System.in));
        InputStream in = terminal.wrapInIfNeeded(unwrappedIn);
        PrintStream out = ConsoleFactory.unwrap(System.out);
        PrintStream err = ConsoleFactory.unwrap(System.err);
        Runnable callback = new Runnable(){

            public void run() {
                try {
                    ConsoleFactory.this.bundleContext.getBundle(0L).stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        String ctype = System.getenv("LC_CTYPE");
        String encoding = ctype;
        encoding = encoding != null && encoding.indexOf(46) > 0 ? encoding.substring(encoding.indexOf(46) + 1) : System.getProperty("input.encoding", Charset.defaultCharset().name());
        this.console = new Console(this.commandProcessor, in, ConsoleFactory.wrap(out), ConsoleFactory.wrap(err), terminal, encoding, callback);
        CommandSession session = this.console.getSession();
        session.put("USER", user);
        session.put("APPLICATION", System.getProperty("karaf.name", "root"));
        session.put("#LINES", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getHeight());
            }
        });
        session.put("#COLUMNS", new Function(){

            @Override
            public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                return Integer.toString(terminal.getWidth());
            }
        });
        if (ctype != null) {
            session.put("LC_CTYPE", ctype);
        }
        session.put(".jline.terminal", terminal);
        session.put("SSH_AUTH_SOCK", agentId);
        session.put("pid", this.getPid());
        boolean delayconsole = Boolean.parseBoolean(System.getProperty("karaf.delay.console"));
        if (delayconsole) {
            new DelayedStarted(this.console, this.bundleContext, unwrappedIn).start();
        } else {
            new Thread((Runnable)this.console, "Karaf Shell Console Thread").start();
        }
    }

    private String getPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] parts = name.split("@");
        return parts[0];
    }

    protected String startAgent(String user) {
        try {
            this.local = SshAgentLoader.load(this.bundleContext);
            String agentId = "local:" + user;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("id", agentId);
            this.registration = this.bundleContext.registerService(SshAgent.class.getName(), (Object)this.local, properties);
            return agentId;
        }
        catch (Throwable e) {
            LOGGER.warn("Error starting ssh agent for local console", e);
            return null;
        }
    }

    protected void stop() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.console != null) {
            this.console.close(false);
        }
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream(stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    static class SshAgentLoader {
        SshAgentLoader() {
        }

        static SshAgent load(BundleContext bundleContext) {
            try {
                AgentImpl agent = new AgentImpl();
                URL url = bundleContext.getBundle().getResource("karaf.key");
                InputStream is = url.openStream();
                ObjectInputStream r = new ObjectInputStream(is);
                KeyPair keyPair = (KeyPair)r.readObject();
                agent.addIdentity(keyPair, "karaf");
                return agent;
            }
            catch (Throwable e) {
                LOGGER.warn("Error starting ssh agent for local console", e);
                return null;
            }
        }
    }
}

